// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;

/**
 * The UploadFileRequest model.
 */
@Fluent
public final class UploadFileRequest {

    /*
     * The file data, in bytes.
     */
    @Generated
    private final FileDetails file;

    /*
     * The intended purpose of the uploaded file. Use `assistants` for Agents and Message files, `vision` for Agents
     * image file inputs, `batch` for Batch API, and `fine-tune` for Fine-tuning.
     */
    @Generated
    private final FilePurpose purpose;

    /*
     * The name of the file.
     */
    @Generated
    private String filename;

    /**
     * Creates an instance of UploadFileRequest class.
     *
     * @param file the file value to set.
     * @param purpose the purpose value to set.
     */
    @Generated
    public UploadFileRequest(FileDetails file, FilePurpose purpose) {
        this.file = file;
        this.purpose = purpose;
    }

    /**
     * Get the file property: The file data, in bytes.
     *
     * @return the file value.
     */
    @Generated
    public FileDetails getFile() {
        return this.file;
    }

    /**
     * Get the purpose property: The intended purpose of the uploaded file. Use `assistants` for Agents and Message
     * files, `vision` for Agents image file inputs, `batch` for Batch API, and `fine-tune` for Fine-tuning.
     *
     * @return the purpose value.
     */
    @Generated
    public FilePurpose getPurpose() {
        return this.purpose;
    }

    /**
     * Get the filename property: The name of the file.
     *
     * @return the filename value.
     */
    @Generated
    public String getFilename() {
        return this.filename;
    }

    /**
     * Set the filename property: The name of the file.
     *
     * @param filename the filename value to set.
     * @return the UploadFileRequest object itself.
     */
    @Generated
    public UploadFileRequest setFilename(String filename) {
        this.filename = filename;
        return this;
    }
}
