// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

/**
 * A vector store is a collection of processed files can be used by the `file_search` tool.
 */
@Immutable
public final class VectorStore implements JsonSerializable<VectorStore> {

    /*
     * The identifier, which can be referenced in API endpoints.
     */
    @Generated
    private final String id;

    /*
     * The object type, which is always `vector_store`
     */
    @Generated
    private final String object = "vector_store";

    /*
     * The Unix timestamp (in seconds) for when the vector store was created.
     */
    @Generated
    private final long createdAt;

    /*
     * The name of the vector store.
     */
    @Generated
    private final String name;

    /*
     * The total number of bytes used by the files in the vector store.
     */
    @Generated
    private final int usageBytes;

    /*
     * Files count grouped by status processed or being processed by this vector store.
     */
    @Generated
    private final VectorStoreFileCount fileCounts;

    /*
     * The status of the vector store, which can be either `expired`, `in_progress`, or `completed`. A status of
     * `completed` indicates that the vector store is ready for use.
     */
    @Generated
    private final VectorStoreStatus status;

    /*
     * Details on when this vector store expires
     */
    @Generated
    private VectorStoreExpirationPolicy expiresAfter;

    /*
     * The Unix timestamp (in seconds) for when the vector store will expire.
     */
    @Generated
    private Long expiresAt;

    /*
     * The Unix timestamp (in seconds) for when the vector store was last active.
     */
    @Generated
    private final Long lastActiveAt;

    /*
     * A set of up to 16 key/value pairs that can be attached to an object, used for storing additional information
     * about that object in a structured format. Keys may be up to 64 characters in length and values may be up to 512
     * characters in length.
     */
    @Generated
    private final Map<String, String> metadata;

    /**
     * Creates an instance of VectorStore class.
     *
     * @param id the id value to set.
     * @param createdAt the createdAt value to set.
     * @param name the name value to set.
     * @param usageBytes the usageBytes value to set.
     * @param fileCounts the fileCounts value to set.
     * @param status the status value to set.
     * @param lastActiveAt the lastActiveAt value to set.
     * @param metadata the metadata value to set.
     */
    @Generated
    private VectorStore(String id, OffsetDateTime createdAt, String name, int usageBytes,
        VectorStoreFileCount fileCounts, VectorStoreStatus status, OffsetDateTime lastActiveAt,
        Map<String, String> metadata) {
        this.id = id;
        if (createdAt == null) {
            this.createdAt = 0L;
        } else {
            this.createdAt = createdAt.toEpochSecond();
        }
        this.name = name;
        this.usageBytes = usageBytes;
        this.fileCounts = fileCounts;
        this.status = status;
        if (lastActiveAt == null) {
            this.lastActiveAt = null;
        } else {
            this.lastActiveAt = lastActiveAt.toEpochSecond();
        }
        this.metadata = metadata;
    }

    /**
     * Get the id property: The identifier, which can be referenced in API endpoints.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the object property: The object type, which is always `vector_store`.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the createdAt property: The Unix timestamp (in seconds) for when the vector store was created.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the name property: The name of the vector store.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the usageBytes property: The total number of bytes used by the files in the vector store.
     *
     * @return the usageBytes value.
     */
    @Generated
    public int getUsageBytes() {
        return this.usageBytes;
    }

    /**
     * Get the fileCounts property: Files count grouped by status processed or being processed by this vector store.
     *
     * @return the fileCounts value.
     */
    @Generated
    public VectorStoreFileCount getFileCounts() {
        return this.fileCounts;
    }

    /**
     * Get the status property: The status of the vector store, which can be either `expired`, `in_progress`, or
     * `completed`. A status of `completed` indicates that the vector store is ready for use.
     *
     * @return the status value.
     */
    @Generated
    public VectorStoreStatus getStatus() {
        return this.status;
    }

    /**
     * Get the expiresAfter property: Details on when this vector store expires.
     *
     * @return the expiresAfter value.
     */
    @Generated
    public VectorStoreExpirationPolicy getExpiresAfter() {
        return this.expiresAfter;
    }

    /**
     * Get the expiresAt property: The Unix timestamp (in seconds) for when the vector store will expire.
     *
     * @return the expiresAt value.
     */
    @Generated
    public OffsetDateTime getExpiresAt() {
        if (this.expiresAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    /**
     * Get the lastActiveAt property: The Unix timestamp (in seconds) for when the vector store was last active.
     *
     * @return the lastActiveAt value.
     */
    @Generated
    public OffsetDateTime getLastActiveAt() {
        if (this.lastActiveAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.lastActiveAt), ZoneOffset.UTC);
    }

    /**
     * Get the metadata property: A set of up to 16 key/value pairs that can be attached to an object, used for storing
     * additional information about that object in a structured format. Keys may be up to 64 characters in length and
     * values may be up to 512 characters in length.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeIntField("usage_bytes", this.usageBytes);
        jsonWriter.writeJsonField("file_counts", this.fileCounts);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeNumberField("last_active_at", this.lastActiveAt);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("expires_after", this.expiresAfter);
        jsonWriter.writeNumberField("expires_at", this.expiresAt);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStore from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStore if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorStore.
     */
    @Generated
    public static VectorStore fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String name = null;
            int usageBytes = 0;
            VectorStoreFileCount fileCounts = null;
            VectorStoreStatus status = null;
            OffsetDateTime lastActiveAt = null;
            Map<String, String> metadata = null;
            VectorStoreExpirationPolicy expiresAfter = null;
            Long expiresAt = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("usage_bytes".equals(fieldName)) {
                    usageBytes = reader.getInt();
                } else if ("file_counts".equals(fieldName)) {
                    fileCounts = VectorStoreFileCount.fromJson(reader);
                } else if ("status".equals(fieldName)) {
                    status = VectorStoreStatus.fromString(reader.getString());
                } else if ("last_active_at".equals(fieldName)) {
                    Long lastActiveAtHolder = reader.getNullable(JsonReader::getLong);
                    if (lastActiveAtHolder != null) {
                        lastActiveAt
                            = OffsetDateTime.ofInstant(Instant.ofEpochSecond(lastActiveAtHolder), ZoneOffset.UTC);
                    }
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else if ("expires_after".equals(fieldName)) {
                    expiresAfter = VectorStoreExpirationPolicy.fromJson(reader);
                } else if ("expires_at".equals(fieldName)) {
                    expiresAt = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }
            VectorStore deserializedVectorStore
                = new VectorStore(id, createdAt, name, usageBytes, fileCounts, status, lastActiveAt, metadata);
            deserializedVectorStore.expiresAfter = expiresAfter;
            deserializedVectorStore.expiresAt = expiresAt;
            return deserializedVectorStore;
        });
    }
}
