// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The default strategy. This strategy currently uses a max_chunk_size_tokens of 800 and chunk_overlap_tokens of 400.
 */
@Immutable
public final class VectorStoreAutoChunkingStrategyRequest extends VectorStoreChunkingStrategyRequest {

    /*
     * The object type.
     */
    @Generated
    private VectorStoreChunkingStrategyRequestType type = VectorStoreChunkingStrategyRequestType.AUTO;

    /**
     * Creates an instance of VectorStoreAutoChunkingStrategyRequest class.
     */
    @Generated
    public VectorStoreAutoChunkingStrategyRequest() {
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public VectorStoreChunkingStrategyRequestType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreAutoChunkingStrategyRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreAutoChunkingStrategyRequest if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorStoreAutoChunkingStrategyRequest.
     */
    @Generated
    public static VectorStoreAutoChunkingStrategyRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorStoreAutoChunkingStrategyRequest deserializedVectorStoreAutoChunkingStrategyRequest
                = new VectorStoreAutoChunkingStrategyRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedVectorStoreAutoChunkingStrategyRequest.type
                        = VectorStoreChunkingStrategyRequestType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedVectorStoreAutoChunkingStrategyRequest;
        });
    }
}
