// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An abstract representation of a vector store chunking strategy configuration.
 */
@Immutable
public class VectorStoreChunkingStrategyRequest implements JsonSerializable<VectorStoreChunkingStrategyRequest> {

    /*
     * The object type.
     */
    @Generated
    private VectorStoreChunkingStrategyRequestType type
        = VectorStoreChunkingStrategyRequestType.fromString("VectorStoreChunkingStrategyRequest");

    /**
     * Creates an instance of VectorStoreChunkingStrategyRequest class.
     */
    @Generated
    public VectorStoreChunkingStrategyRequest() {
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    public VectorStoreChunkingStrategyRequestType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreChunkingStrategyRequest from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreChunkingStrategyRequest if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorStoreChunkingStrategyRequest.
     */
    @Generated
    public static VectorStoreChunkingStrategyRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("auto".equals(discriminatorValue)) {
                    return VectorStoreAutoChunkingStrategyRequest.fromJson(readerToUse.reset());
                } else if ("static".equals(discriminatorValue)) {
                    return VectorStoreStaticChunkingStrategyRequest.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static VectorStoreChunkingStrategyRequest fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorStoreChunkingStrategyRequest deserializedVectorStoreChunkingStrategyRequest
                = new VectorStoreChunkingStrategyRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedVectorStoreChunkingStrategyRequest.type
                        = VectorStoreChunkingStrategyRequestType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedVectorStoreChunkingStrategyRequest;
        });
    }
}
