// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An abstract representation of a vector store chunking strategy configuration.
 */
@Immutable
public class VectorStoreChunkingStrategyResponse implements JsonSerializable<VectorStoreChunkingStrategyResponse> {

    /*
     * The object type.
     */
    @Generated
    private VectorStoreChunkingStrategyResponseType type
        = VectorStoreChunkingStrategyResponseType.fromString("VectorStoreChunkingStrategyResponse");

    /**
     * Creates an instance of VectorStoreChunkingStrategyResponse class.
     */
    @Generated
    protected VectorStoreChunkingStrategyResponse() {
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    public VectorStoreChunkingStrategyResponseType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreChunkingStrategyResponse from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreChunkingStrategyResponse if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VectorStoreChunkingStrategyResponse.
     */
    @Generated
    public static VectorStoreChunkingStrategyResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("other".equals(discriminatorValue)) {
                    return VectorStoreAutoChunkingStrategyResponse.fromJson(readerToUse.reset());
                } else if ("static".equals(discriminatorValue)) {
                    return VectorStoreStaticChunkingStrategyResponse.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static VectorStoreChunkingStrategyResponse fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorStoreChunkingStrategyResponse deserializedVectorStoreChunkingStrategyResponse
                = new VectorStoreChunkingStrategyResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedVectorStoreChunkingStrategyResponse.type
                        = VectorStoreChunkingStrategyResponseType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedVectorStoreChunkingStrategyResponse;
        });
    }
}
