// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Vector storage configuration is the list of data sources, used when multiple
 * files can be used for the enterprise file search.
 */
@Immutable
public final class VectorStoreConfiguration implements JsonSerializable<VectorStoreConfiguration> {

    /*
     * Data sources
     */
    @Generated
    private final List<VectorStoreDataSource> dataSources;

    /**
     * Creates an instance of VectorStoreConfiguration class.
     *
     * @param dataSources the dataSources value to set.
     */
    @Generated
    public VectorStoreConfiguration(List<VectorStoreDataSource> dataSources) {
        this.dataSources = dataSources;
    }

    /**
     * Get the dataSources property: Data sources.
     *
     * @return the dataSources value.
     */
    @Generated
    public List<VectorStoreDataSource> getDataSources() {
        return this.dataSources;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("data_sources", this.dataSources, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreConfiguration from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreConfiguration if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorStoreConfiguration.
     */
    @Generated
    public static VectorStoreConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<VectorStoreDataSource> dataSources = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data_sources".equals(fieldName)) {
                    dataSources = reader.readArray(reader1 -> VectorStoreDataSource.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new VectorStoreConfiguration(dataSources);
        });
    }
}
