// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The structure, containing the list of vector storage configurations i.e. the list of azure asset IDs.
 */
@Immutable
public final class VectorStoreConfigurations implements JsonSerializable<VectorStoreConfigurations> {

    /*
     * Name
     */
    @Generated
    private final String storeName;

    /*
     * Configurations
     */
    @Generated
    private final VectorStoreConfiguration storeConfiguration;

    /**
     * Creates an instance of VectorStoreConfigurations class.
     *
     * @param storeName the storeName value to set.
     * @param storeConfiguration the storeConfiguration value to set.
     */
    @Generated
    public VectorStoreConfigurations(String storeName, VectorStoreConfiguration storeConfiguration) {
        this.storeName = storeName;
        this.storeConfiguration = storeConfiguration;
    }

    /**
     * Get the storeName property: Name.
     *
     * @return the storeName value.
     */
    @Generated
    public String getStoreName() {
        return this.storeName;
    }

    /**
     * Get the storeConfiguration property: Configurations.
     *
     * @return the storeConfiguration value.
     */
    @Generated
    public VectorStoreConfiguration getStoreConfiguration() {
        return this.storeConfiguration;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.storeName);
        jsonWriter.writeJsonField("configuration", this.storeConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreConfigurations from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreConfigurations if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorStoreConfigurations.
     */
    @Generated
    public static VectorStoreConfigurations fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String storeName = null;
            VectorStoreConfiguration storeConfiguration = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    storeName = reader.getString();
                } else if ("configuration".equals(fieldName)) {
                    storeConfiguration = VectorStoreConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return new VectorStoreConfigurations(storeName, storeConfiguration);
        });
    }
}
