// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The structure, containing Azure asset URI path and the asset type of the file used as a data source
 * for the enterprise file search.
 */
@Immutable
public final class VectorStoreDataSource implements JsonSerializable<VectorStoreDataSource> {

    /*
     * Asset URI.
     */
    @Generated
    private final String assetIdentifier;

    /*
     * The asset type
     */
    @Generated
    private final VectorStoreDataSourceAssetType assetType;

    /**
     * Creates an instance of VectorStoreDataSource class.
     *
     * @param assetIdentifier the assetIdentifier value to set.
     * @param assetType the assetType value to set.
     */
    @Generated
    public VectorStoreDataSource(String assetIdentifier, VectorStoreDataSourceAssetType assetType) {
        this.assetIdentifier = assetIdentifier;
        this.assetType = assetType;
    }

    /**
     * Get the assetIdentifier property: Asset URI.
     *
     * @return the assetIdentifier value.
     */
    @Generated
    public String getAssetIdentifier() {
        return this.assetIdentifier;
    }

    /**
     * Get the assetType property: The asset type.
     *
     * @return the assetType value.
     */
    @Generated
    public VectorStoreDataSourceAssetType getAssetType() {
        return this.assetType;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.assetIdentifier);
        jsonWriter.writeStringField("type", this.assetType == null ? null : this.assetType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreDataSource from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreDataSource if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorStoreDataSource.
     */
    @Generated
    public static VectorStoreDataSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String assetIdentifier = null;
            VectorStoreDataSourceAssetType assetType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("uri".equals(fieldName)) {
                    assetIdentifier = reader.getString();
                } else if ("type".equals(fieldName)) {
                    assetType = VectorStoreDataSourceAssetType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return new VectorStoreDataSource(assetIdentifier, assetType);
        });
    }
}
