// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of vector storage asset. Asset type may be a uri_asset, in this case it should contain asset URI ID,
 * in the case of id_asset it should contain the data ID.
 */
public final class VectorStoreDataSourceAssetType extends ExpandableStringEnum<VectorStoreDataSourceAssetType> {

    /**
     * Azure URI.
     */
    @Generated
    public static final VectorStoreDataSourceAssetType URI_ASSET = fromString("uri_asset");

    /**
     * The data ID.
     */
    @Generated
    public static final VectorStoreDataSourceAssetType ID_ASSET = fromString("id_asset");

    /**
     * Creates a new instance of VectorStoreDataSourceAssetType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public VectorStoreDataSourceAssetType() {
    }

    /**
     * Creates or finds a VectorStoreDataSourceAssetType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding VectorStoreDataSourceAssetType.
     */
    @Generated
    public static VectorStoreDataSourceAssetType fromString(String name) {
        return fromString(name, VectorStoreDataSourceAssetType.class);
    }

    /**
     * Gets known VectorStoreDataSourceAssetType values.
     *
     * @return known VectorStoreDataSourceAssetType values.
     */
    @Generated
    public static Collection<VectorStoreDataSourceAssetType> values() {
        return values(VectorStoreDataSourceAssetType.class);
    }
}
