// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The expiration policy for a vector store.
 */
@Immutable
public final class VectorStoreExpirationPolicy implements JsonSerializable<VectorStoreExpirationPolicy> {

    /*
     * Anchor timestamp after which the expiration policy applies. Supported anchors: `last_active_at`.
     */
    @Generated
    private final VectorStoreExpirationPolicyAnchor anchor;

    /*
     * The anchor timestamp after which the expiration policy applies.
     */
    @Generated
    private final int days;

    /**
     * Creates an instance of VectorStoreExpirationPolicy class.
     *
     * @param anchor the anchor value to set.
     * @param days the days value to set.
     */
    @Generated
    public VectorStoreExpirationPolicy(VectorStoreExpirationPolicyAnchor anchor, int days) {
        this.anchor = anchor;
        this.days = days;
    }

    /**
     * Get the anchor property: Anchor timestamp after which the expiration policy applies. Supported anchors:
     * `last_active_at`.
     *
     * @return the anchor value.
     */
    @Generated
    public VectorStoreExpirationPolicyAnchor getAnchor() {
        return this.anchor;
    }

    /**
     * Get the days property: The anchor timestamp after which the expiration policy applies.
     *
     * @return the days value.
     */
    @Generated
    public int getDays() {
        return this.days;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("anchor", this.anchor == null ? null : this.anchor.toString());
        jsonWriter.writeIntField("days", this.days);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreExpirationPolicy from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreExpirationPolicy if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorStoreExpirationPolicy.
     */
    @Generated
    public static VectorStoreExpirationPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorStoreExpirationPolicyAnchor anchor = null;
            int days = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("anchor".equals(fieldName)) {
                    anchor = VectorStoreExpirationPolicyAnchor.fromString(reader.getString());
                } else if ("days".equals(fieldName)) {
                    days = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }
            return new VectorStoreExpirationPolicy(anchor, days);
        });
    }
}
