// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Describes the relationship between the days and the expiration of this vector store.
 */
public final class VectorStoreExpirationPolicyAnchor extends ExpandableStringEnum<VectorStoreExpirationPolicyAnchor> {

    /**
     * The expiration policy is based on the last time the vector store was active.
     */
    @Generated
    public static final VectorStoreExpirationPolicyAnchor LAST_ACTIVE_AT = fromString("last_active_at");

    /**
     * Creates a new instance of VectorStoreExpirationPolicyAnchor value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public VectorStoreExpirationPolicyAnchor() {
    }

    /**
     * Creates or finds a VectorStoreExpirationPolicyAnchor from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding VectorStoreExpirationPolicyAnchor.
     */
    @Generated
    public static VectorStoreExpirationPolicyAnchor fromString(String name) {
        return fromString(name, VectorStoreExpirationPolicyAnchor.class);
    }

    /**
     * Gets known VectorStoreExpirationPolicyAnchor values.
     *
     * @return known VectorStoreExpirationPolicyAnchor values.
     */
    @Generated
    public static Collection<VectorStoreExpirationPolicyAnchor> values() {
        return values(VectorStoreExpirationPolicyAnchor.class);
    }
}
