// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

/**
 * A batch of files attached to a vector store.
 */
@Immutable
public final class VectorStoreFileBatch implements JsonSerializable<VectorStoreFileBatch> {

    /*
     * The identifier, which can be referenced in API endpoints.
     */
    @Generated
    private final String id;

    /*
     * The object type, which is always `vector_store.file_batch`.
     */
    @Generated
    private final String object = "vector_store.files_batch";

    /*
     * The Unix timestamp (in seconds) for when the vector store files batch was created.
     */
    @Generated
    private final long createdAt;

    /*
     * The ID of the vector store that the file is attached to.
     */
    @Generated
    private final String vectorStoreId;

    /*
     * The status of the vector store files batch, which can be either `in_progress`, `completed`, `cancelled` or
     * `failed`.
     */
    @Generated
    private final VectorStoreFileBatchStatus status;

    /*
     * Files count grouped by status processed or being processed by this vector store.
     */
    @Generated
    private final VectorStoreFileCount fileCounts;

    /**
     * Creates an instance of VectorStoreFileBatch class.
     *
     * @param id the id value to set.
     * @param createdAt the createdAt value to set.
     * @param vectorStoreId the vectorStoreId value to set.
     * @param status the status value to set.
     * @param fileCounts the fileCounts value to set.
     */
    @Generated
    private VectorStoreFileBatch(String id, OffsetDateTime createdAt, String vectorStoreId,
        VectorStoreFileBatchStatus status, VectorStoreFileCount fileCounts) {
        this.id = id;
        if (createdAt == null) {
            this.createdAt = 0L;
        } else {
            this.createdAt = createdAt.toEpochSecond();
        }
        this.vectorStoreId = vectorStoreId;
        this.status = status;
        this.fileCounts = fileCounts;
    }

    /**
     * Get the id property: The identifier, which can be referenced in API endpoints.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the object property: The object type, which is always `vector_store.file_batch`.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the createdAt property: The Unix timestamp (in seconds) for when the vector store files batch was created.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the vectorStoreId property: The ID of the vector store that the file is attached to.
     *
     * @return the vectorStoreId value.
     */
    @Generated
    public String getVectorStoreId() {
        return this.vectorStoreId;
    }

    /**
     * Get the status property: The status of the vector store files batch, which can be either `in_progress`,
     * `completed`, `cancelled` or `failed`.
     *
     * @return the status value.
     */
    @Generated
    public VectorStoreFileBatchStatus getStatus() {
        return this.status;
    }

    /**
     * Get the fileCounts property: Files count grouped by status processed or being processed by this vector store.
     *
     * @return the fileCounts value.
     */
    @Generated
    public VectorStoreFileCount getFileCounts() {
        return this.fileCounts;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("vector_store_id", this.vectorStoreId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("file_counts", this.fileCounts);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreFileBatch from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreFileBatch if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorStoreFileBatch.
     */
    @Generated
    public static VectorStoreFileBatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String vectorStoreId = null;
            VectorStoreFileBatchStatus status = null;
            VectorStoreFileCount fileCounts = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                } else if ("vector_store_id".equals(fieldName)) {
                    vectorStoreId = reader.getString();
                } else if ("status".equals(fieldName)) {
                    status = VectorStoreFileBatchStatus.fromString(reader.getString());
                } else if ("file_counts".equals(fieldName)) {
                    fileCounts = VectorStoreFileCount.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return new VectorStoreFileBatch(id, createdAt, vectorStoreId, status, fileCounts);
        });
    }
}
