// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The status of the vector store file batch.
 */
public final class VectorStoreFileBatchStatus extends ExpandableStringEnum<VectorStoreFileBatchStatus> {

    /**
     * The vector store is still processing this file batch.
     */
    @Generated
    public static final VectorStoreFileBatchStatus IN_PROGRESS = fromString("in_progress");

    /**
     * the vector store file batch is ready for use.
     */
    @Generated
    public static final VectorStoreFileBatchStatus COMPLETED = fromString("completed");

    /**
     * The vector store file batch was cancelled.
     */
    @Generated
    public static final VectorStoreFileBatchStatus CANCELLED = fromString("cancelled");

    /**
     * The vector store file batch failed to process.
     */
    @Generated
    public static final VectorStoreFileBatchStatus FAILED = fromString("failed");

    /**
     * Creates a new instance of VectorStoreFileBatchStatus value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public VectorStoreFileBatchStatus() {
    }

    /**
     * Creates or finds a VectorStoreFileBatchStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding VectorStoreFileBatchStatus.
     */
    @Generated
    public static VectorStoreFileBatchStatus fromString(String name) {
        return fromString(name, VectorStoreFileBatchStatus.class);
    }

    /**
     * Gets known VectorStoreFileBatchStatus values.
     *
     * @return known VectorStoreFileBatchStatus values.
     */
    @Generated
    public static Collection<VectorStoreFileBatchStatus> values() {
        return values(VectorStoreFileBatchStatus.class);
    }
}
