// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Counts of files processed or being processed by this vector store grouped by status.
 */
@Immutable
public final class VectorStoreFileCount implements JsonSerializable<VectorStoreFileCount> {

    /*
     * The number of files that are currently being processed.
     */
    @Generated
    private final int inProgress;

    /*
     * The number of files that have been successfully processed.
     */
    @Generated
    private final int completed;

    /*
     * The number of files that have failed to process.
     */
    @Generated
    private final int failed;

    /*
     * The number of files that were cancelled.
     */
    @Generated
    private final int cancelled;

    /*
     * The total number of files.
     */
    @Generated
    private final int total;

    /**
     * Creates an instance of VectorStoreFileCount class.
     *
     * @param inProgress the inProgress value to set.
     * @param completed the completed value to set.
     * @param failed the failed value to set.
     * @param cancelled the cancelled value to set.
     * @param total the total value to set.
     */
    @Generated
    private VectorStoreFileCount(int inProgress, int completed, int failed, int cancelled, int total) {
        this.inProgress = inProgress;
        this.completed = completed;
        this.failed = failed;
        this.cancelled = cancelled;
        this.total = total;
    }

    /**
     * Get the inProgress property: The number of files that are currently being processed.
     *
     * @return the inProgress value.
     */
    @Generated
    public int getInProgress() {
        return this.inProgress;
    }

    /**
     * Get the completed property: The number of files that have been successfully processed.
     *
     * @return the completed value.
     */
    @Generated
    public int getCompleted() {
        return this.completed;
    }

    /**
     * Get the failed property: The number of files that have failed to process.
     *
     * @return the failed value.
     */
    @Generated
    public int getFailed() {
        return this.failed;
    }

    /**
     * Get the cancelled property: The number of files that were cancelled.
     *
     * @return the cancelled value.
     */
    @Generated
    public int getCancelled() {
        return this.cancelled;
    }

    /**
     * Get the total property: The total number of files.
     *
     * @return the total value.
     */
    @Generated
    public int getTotal() {
        return this.total;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("in_progress", this.inProgress);
        jsonWriter.writeIntField("completed", this.completed);
        jsonWriter.writeIntField("failed", this.failed);
        jsonWriter.writeIntField("cancelled", this.cancelled);
        jsonWriter.writeIntField("total", this.total);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreFileCount from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreFileCount if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorStoreFileCount.
     */
    @Generated
    public static VectorStoreFileCount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int inProgress = 0;
            int completed = 0;
            int failed = 0;
            int cancelled = 0;
            int total = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("in_progress".equals(fieldName)) {
                    inProgress = reader.getInt();
                } else if ("completed".equals(fieldName)) {
                    completed = reader.getInt();
                } else if ("failed".equals(fieldName)) {
                    failed = reader.getInt();
                } else if ("cancelled".equals(fieldName)) {
                    cancelled = reader.getInt();
                } else if ("total".equals(fieldName)) {
                    total = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }
            return new VectorStoreFileCount(inProgress, completed, failed, cancelled, total);
        });
    }
}
