// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details on the error that may have occurred while processing a file for this vector store.
 */
@Immutable
public final class VectorStoreFileError implements JsonSerializable<VectorStoreFileError> {

    /*
     * One of `server_error` or `rate_limit_exceeded`.
     */
    @Generated
    private final VectorStoreFileErrorCode code;

    /*
     * A human-readable description of the error.
     */
    @Generated
    private final String message;

    /**
     * Creates an instance of VectorStoreFileError class.
     *
     * @param code the code value to set.
     * @param message the message value to set.
     */
    @Generated
    private VectorStoreFileError(VectorStoreFileErrorCode code, String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * Get the code property: One of `server_error` or `rate_limit_exceeded`.
     *
     * @return the code value.
     */
    @Generated
    public VectorStoreFileErrorCode getCode() {
        return this.code;
    }

    /**
     * Get the message property: A human-readable description of the error.
     *
     * @return the message value.
     */
    @Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code == null ? null : this.code.toString());
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreFileError from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreFileError if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorStoreFileError.
     */
    @Generated
    public static VectorStoreFileError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorStoreFileErrorCode code = null;
            String message = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = VectorStoreFileErrorCode.fromString(reader.getString());
                } else if ("message".equals(fieldName)) {
                    message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new VectorStoreFileError(code, message);
        });
    }
}
