// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Error code variants for vector store file processing.
 */
public final class VectorStoreFileErrorCode extends ExpandableStringEnum<VectorStoreFileErrorCode> {

    /**
     * An server error occurred.
     */
    @Generated
    public static final VectorStoreFileErrorCode SERVER_ERROR = fromString("server_error");

    /**
     * The file is not valid.
     */
    @Generated
    public static final VectorStoreFileErrorCode INVALID_FILE = fromString("invalid_file");

    /**
     * The file is of unsupported type.
     */
    @Generated
    public static final VectorStoreFileErrorCode UNSUPPORTED_FILE = fromString("unsupported_file");

    /**
     * Creates a new instance of VectorStoreFileErrorCode value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public VectorStoreFileErrorCode() {
    }

    /**
     * Creates or finds a VectorStoreFileErrorCode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding VectorStoreFileErrorCode.
     */
    @Generated
    public static VectorStoreFileErrorCode fromString(String name) {
        return fromString(name, VectorStoreFileErrorCode.class);
    }

    /**
     * Gets known VectorStoreFileErrorCode values.
     *
     * @return known VectorStoreFileErrorCode values.
     */
    @Generated
    public static Collection<VectorStoreFileErrorCode> values() {
        return values(VectorStoreFileErrorCode.class);
    }
}
