// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Vector store file status.
 */
public final class VectorStoreFileStatus extends ExpandableStringEnum<VectorStoreFileStatus> {

    /**
     * The file is currently being processed.
     */
    @Generated
    public static final VectorStoreFileStatus IN_PROGRESS = fromString("in_progress");

    /**
     * The file has been successfully processed.
     */
    @Generated
    public static final VectorStoreFileStatus COMPLETED = fromString("completed");

    /**
     * The file has failed to process.
     */
    @Generated
    public static final VectorStoreFileStatus FAILED = fromString("failed");

    /**
     * The file was cancelled.
     */
    @Generated
    public static final VectorStoreFileStatus CANCELLED = fromString("cancelled");

    /**
     * Creates a new instance of VectorStoreFileStatus value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public VectorStoreFileStatus() {
    }

    /**
     * Creates or finds a VectorStoreFileStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding VectorStoreFileStatus.
     */
    @Generated
    public static VectorStoreFileStatus fromString(String name) {
        return fromString(name, VectorStoreFileStatus.class);
    }

    /**
     * Gets known VectorStoreFileStatus values.
     *
     * @return known VectorStoreFileStatus values.
     */
    @Generated
    public static Collection<VectorStoreFileStatus> values() {
        return values(VectorStoreFileStatus.class);
    }
}
