// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Query parameter filter for vector store file retrieval endpoint.
 */
public final class VectorStoreFileStatusFilter extends ExpandableStringEnum<VectorStoreFileStatusFilter> {

    /**
     * Retrieve only files that are currently being processed.
     */
    @Generated
    public static final VectorStoreFileStatusFilter IN_PROGRESS = fromString("in_progress");

    /**
     * Retrieve only files that have been successfully processed.
     */
    @Generated
    public static final VectorStoreFileStatusFilter COMPLETED = fromString("completed");

    /**
     * Retrieve only files that have failed to process.
     */
    @Generated
    public static final VectorStoreFileStatusFilter FAILED = fromString("failed");

    /**
     * Retrieve only files that were cancelled.
     */
    @Generated
    public static final VectorStoreFileStatusFilter CANCELLED = fromString("cancelled");

    /**
     * Creates a new instance of VectorStoreFileStatusFilter value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public VectorStoreFileStatusFilter() {
    }

    /**
     * Creates or finds a VectorStoreFileStatusFilter from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding VectorStoreFileStatusFilter.
     */
    @Generated
    public static VectorStoreFileStatusFilter fromString(String name) {
        return fromString(name, VectorStoreFileStatusFilter.class);
    }

    /**
     * Gets known VectorStoreFileStatusFilter values.
     *
     * @return known VectorStoreFileStatusFilter values.
     */
    @Generated
    public static Collection<VectorStoreFileStatusFilter> values() {
        return values(VectorStoreFileStatusFilter.class);
    }
}
