// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A statically configured chunking strategy.
 */
@Immutable
public final class VectorStoreStaticChunkingStrategyResponse extends VectorStoreChunkingStrategyResponse {

    /*
     * The object type.
     */
    @Generated
    private VectorStoreChunkingStrategyResponseType type = VectorStoreChunkingStrategyResponseType.STATIC;

    /*
     * The options for the static chunking strategy.
     */
    @Generated
    private final VectorStoreStaticChunkingStrategyOptions staticProperty;

    /**
     * Creates an instance of VectorStoreStaticChunkingStrategyResponse class.
     *
     * @param staticProperty the staticProperty value to set.
     */
    @Generated
    private VectorStoreStaticChunkingStrategyResponse(VectorStoreStaticChunkingStrategyOptions staticProperty) {
        this.staticProperty = staticProperty;
    }

    /**
     * Get the type property: The object type.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public VectorStoreChunkingStrategyResponseType getType() {
        return this.type;
    }

    /**
     * Get the staticProperty property: The options for the static chunking strategy.
     *
     * @return the staticProperty value.
     */
    @Generated
    public VectorStoreStaticChunkingStrategyOptions getStaticProperty() {
        return this.staticProperty;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("static", this.staticProperty);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorStoreStaticChunkingStrategyResponse from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorStoreStaticChunkingStrategyResponse if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorStoreStaticChunkingStrategyResponse.
     */
    @Generated
    public static VectorStoreStaticChunkingStrategyResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VectorStoreStaticChunkingStrategyOptions staticProperty = null;
            VectorStoreChunkingStrategyResponseType type = VectorStoreChunkingStrategyResponseType.STATIC;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("static".equals(fieldName)) {
                    staticProperty = VectorStoreStaticChunkingStrategyOptions.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = VectorStoreChunkingStrategyResponseType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            VectorStoreStaticChunkingStrategyResponse deserializedVectorStoreStaticChunkingStrategyResponse
                = new VectorStoreStaticChunkingStrategyResponse(staticProperty);
            deserializedVectorStoreStaticChunkingStrategyResponse.type = type;
            return deserializedVectorStoreStaticChunkingStrategyResponse;
        });
    }
}
