// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.agents.persistent.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Vector store possible status.
 */
public final class VectorStoreStatus extends ExpandableStringEnum<VectorStoreStatus> {

    /**
     * expired status indicates that this vector store has expired and is no longer available for use.
     */
    @Generated
    public static final VectorStoreStatus EXPIRED = fromString("expired");

    /**
     * in_progress status indicates that this vector store is still processing files.
     */
    @Generated
    public static final VectorStoreStatus IN_PROGRESS = fromString("in_progress");

    /**
     * completed status indicates that this vector store is ready for use.
     */
    @Generated
    public static final VectorStoreStatus COMPLETED = fromString("completed");

    /**
     * Creates a new instance of VectorStoreStatus value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public VectorStoreStatus() {
    }

    /**
     * Creates or finds a VectorStoreStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding VectorStoreStatus.
     */
    @Generated
    public static VectorStoreStatus fromString(String name) {
        return fromString(name, VectorStoreStatus.class);
    }

    /**
     * Gets known VectorStoreStatus values.
     *
     * @return known VectorStoreStatus values.
     */
    @Generated
    public static Collection<VectorStoreStatus> values() {
        return values(VectorStoreStatus.class);
    }
}
