/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.MessagesImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateMessageRequest;
import com.azure.ai.agents.persistent.implementation.models.UpdateMessageRequest;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.MessageAttachment;
import com.azure.ai.agents.persistent.models.MessageRole;
import com.azure.ai.agents.persistent.models.ThreadMessage;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PersistentAgentsClientBuilder.class, isAsync=true)
public final class MessagesAsyncClient {
    private final MessagesImpl serviceClient;

    MessagesAsyncClient(MessagesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createMessageWithResponse(String threadId, BinaryData createMessageRequest, RequestOptions requestOptions) {
        return this.serviceClient.createMessageWithResponseAsync(threadId, createMessageRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMessages(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.listMessagesAsync(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMessageWithResponse(String threadId, String messageId, RequestOptions requestOptions) {
        return this.serviceClient.getMessageWithResponseAsync(threadId, messageId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateMessageWithResponse(String threadId, String messageId, BinaryData updateMessageRequest, RequestOptions requestOptions) {
        return this.serviceClient.updateMessageWithResponseAsync(threadId, messageId, updateMessageRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> createMessage(String threadId, MessageRole role, BinaryData content, List<MessageAttachment> attachments, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        CreateMessageRequest createMessageRequestObj = new CreateMessageRequest(role, content).setAttachments(attachments).setMetadata(metadata);
        BinaryData createMessageRequest = BinaryData.fromObject((Object)createMessageRequestObj);
        return this.createMessageWithResponse(threadId, createMessageRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> createMessage(String threadId, MessageRole role, BinaryData content) {
        RequestOptions requestOptions = new RequestOptions();
        CreateMessageRequest createMessageRequestObj = new CreateMessageRequest(role, content);
        BinaryData createMessageRequest = BinaryData.fromObject((Object)createMessageRequestObj);
        return this.createMessageWithResponse(threadId, createMessageRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ThreadMessage> listMessages(String threadId, String runId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (runId != null) {
            requestOptions.addQueryParam("run_id", runId, false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listMessages(threadId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ThreadMessage> listMessages(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listMessages(threadId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> getMessage(String threadId, String messageId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getMessageWithResponse(threadId, messageId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> updateMessage(String threadId, String messageId, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest updateMessageRequestObj = new UpdateMessageRequest().setMetadata(metadata);
        BinaryData updateMessageRequest = BinaryData.fromObject((Object)updateMessageRequestObj);
        return this.updateMessageWithResponse(threadId, messageId, updateMessageRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> updateMessage(String threadId, String messageId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest updateMessageRequestObj = new UpdateMessageRequest();
        BinaryData updateMessageRequest = BinaryData.fromObject((Object)updateMessageRequestObj);
        return this.updateMessageWithResponse(threadId, messageId, updateMessageRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadMessage)protocolMethodData.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> createMessage(String threadId, MessageRole role, String content) {
        BinaryData binaryContent = BinaryData.fromString((String)content);
        return this.createMessage(threadId, role, binaryContent);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadMessage> createMessage(String threadId, MessageRole role, String content, List<MessageAttachment> attachments, Map<String, String> metadata) {
        BinaryData binaryContent = BinaryData.fromString((String)content);
        return this.createMessage(threadId, role, binaryContent, attachments, metadata);
    }
}

