/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.MessagesImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateMessageRequest;
import com.azure.ai.agents.persistent.implementation.models.UpdateMessageRequest;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.MessageAttachment;
import com.azure.ai.agents.persistent.models.MessageRole;
import com.azure.ai.agents.persistent.models.ThreadMessage;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import java.util.List;
import java.util.Map;

@ServiceClient(builder=PersistentAgentsClientBuilder.class)
public final class MessagesClient {
    private final MessagesImpl serviceClient;

    MessagesClient(MessagesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createMessageWithResponse(String threadId, BinaryData createMessageRequest, RequestOptions requestOptions) {
        return this.serviceClient.createMessageWithResponse(threadId, createMessageRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMessages(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.listMessages(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMessageWithResponse(String threadId, String messageId, RequestOptions requestOptions) {
        return this.serviceClient.getMessageWithResponse(threadId, messageId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateMessageWithResponse(String threadId, String messageId, BinaryData updateMessageRequest, RequestOptions requestOptions) {
        return this.serviceClient.updateMessageWithResponse(threadId, messageId, updateMessageRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage createMessage(String threadId, MessageRole role, BinaryData content, List<MessageAttachment> attachments, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        CreateMessageRequest createMessageRequestObj = new CreateMessageRequest(role, content).setAttachments(attachments).setMetadata(metadata);
        BinaryData createMessageRequest = BinaryData.fromObject((Object)createMessageRequestObj);
        return (ThreadMessage)((BinaryData)this.createMessageWithResponse(threadId, createMessageRequest, requestOptions).getValue()).toObject(ThreadMessage.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage createMessage(String threadId, MessageRole role, BinaryData content) {
        RequestOptions requestOptions = new RequestOptions();
        CreateMessageRequest createMessageRequestObj = new CreateMessageRequest(role, content);
        BinaryData createMessageRequest = BinaryData.fromObject((Object)createMessageRequestObj);
        return (ThreadMessage)((BinaryData)this.createMessageWithResponse(threadId, createMessageRequest, requestOptions).getValue()).toObject(ThreadMessage.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ThreadMessage> listMessages(String threadId, String runId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (runId != null) {
            requestOptions.addQueryParam("run_id", runId, false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.serviceClient.listMessages(threadId, requestOptions).mapPage(bodyItemValue -> (ThreadMessage)bodyItemValue.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ThreadMessage> listMessages(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listMessages(threadId, requestOptions).mapPage(bodyItemValue -> (ThreadMessage)bodyItemValue.toObject(ThreadMessage.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage getMessage(String threadId, String messageId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadMessage)((BinaryData)this.getMessageWithResponse(threadId, messageId, requestOptions).getValue()).toObject(ThreadMessage.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage updateMessage(String threadId, String messageId, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest updateMessageRequestObj = new UpdateMessageRequest().setMetadata(metadata);
        BinaryData updateMessageRequest = BinaryData.fromObject((Object)updateMessageRequestObj);
        return (ThreadMessage)((BinaryData)this.updateMessageWithResponse(threadId, messageId, updateMessageRequest, requestOptions).getValue()).toObject(ThreadMessage.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage updateMessage(String threadId, String messageId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateMessageRequest updateMessageRequestObj = new UpdateMessageRequest();
        BinaryData updateMessageRequest = BinaryData.fromObject((Object)updateMessageRequestObj);
        return (ThreadMessage)((BinaryData)this.updateMessageWithResponse(threadId, messageId, updateMessageRequest, requestOptions).getValue()).toObject(ThreadMessage.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage createMessage(String threadId, MessageRole role, String content, List<MessageAttachment> attachments, Map<String, String> metadata) {
        BinaryData binaryContent = BinaryData.fromString((String)content);
        return this.createMessage(threadId, role, binaryContent, attachments, metadata);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadMessage createMessage(String threadId, MessageRole role, String content) {
        BinaryData binaryContent = BinaryData.fromString((String)content);
        return this.createMessage(threadId, role, binaryContent);
    }
}

