/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.PersistentAgentsAdministrationImpl;
import com.azure.ai.agents.persistent.implementation.models.AgentDeletionStatus;
import com.azure.ai.agents.persistent.implementation.models.CreateAgentRequest;
import com.azure.ai.agents.persistent.implementation.models.UpdateAgentRequest;
import com.azure.ai.agents.persistent.models.CreateAgentOptions;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.PersistentAgent;
import com.azure.ai.agents.persistent.models.UpdateAgentOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;

@ServiceClient(builder=PersistentAgentsClientBuilder.class)
public final class PersistentAgentsAdministrationClient {
    private static final ClientLogger LOGGER = new ClientLogger(PersistentAgentsAdministrationClient.class);
    private final PersistentAgentsAdministrationImpl serviceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAgentWithResponse(String assistantId, RequestOptions requestOptions) {
        return this.serviceClient.getAgentWithResponse(assistantId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createAgentWithResponse(BinaryData createAgentRequest, RequestOptions requestOptions) {
        return this.serviceClient.createAgentWithResponse(createAgentRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateAgentWithResponse(String assistantId, BinaryData updateAgentRequest, RequestOptions requestOptions) {
        return this.serviceClient.updateAgentWithResponse(assistantId, updateAgentRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listAgents(RequestOptions requestOptions) {
        return this.serviceClient.listAgents(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PersistentAgent getAgent(String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        return (PersistentAgent)((BinaryData)this.getAgentWithResponse(assistantId, requestOptions).getValue()).toObject(PersistentAgent.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PersistentAgent createAgent(CreateAgentOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        CreateAgentRequest createAgentRequestObj = new CreateAgentRequest(options.getModel()).setName(options.getName()).setDescription(options.getDescription()).setInstructions(options.getInstructions()).setTools(options.getTools()).setToolResources(options.getToolResources()).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setResponseFormat(options.getResponseFormat()).setMetadata(options.getMetadata());
        BinaryData createAgentRequest = BinaryData.fromObject((Object)createAgentRequestObj);
        return (PersistentAgent)((BinaryData)this.createAgentWithResponse(createAgentRequest, requestOptions).getValue()).toObject(PersistentAgent.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PersistentAgent updateAgent(UpdateAgentOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        String assistantId = options.getAssistantId();
        UpdateAgentRequest updateAgentRequestObj = new UpdateAgentRequest().setModel(options.getModel()).setName(options.getName()).setDescription(options.getDescription()).setInstructions(options.getInstructions()).setTools(options.getTools()).setToolResources(options.getToolResources()).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setResponseFormat(options.getResponseFormat()).setMetadata(options.getMetadata());
        BinaryData updateAgentRequest = BinaryData.fromObject((Object)updateAgentRequestObj);
        return (PersistentAgent)((BinaryData)this.updateAgentWithResponse(assistantId, updateAgentRequest, requestOptions).getValue()).toObject(PersistentAgent.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PersistentAgent> listAgents(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.serviceClient.listAgents(requestOptions).mapPage(bodyItemValue -> (PersistentAgent)bodyItemValue.toObject(PersistentAgent.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PersistentAgent> listAgents() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listAgents(requestOptions).mapPage(bodyItemValue -> (PersistentAgent)bodyItemValue.toObject(PersistentAgent.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> deleteAgentInternalWithResponse(String assistantId, RequestOptions requestOptions) {
        return this.serviceClient.deleteAgentInternalWithResponse(assistantId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    AgentDeletionStatus deleteAgentInternal(String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        return (AgentDeletionStatus)((BinaryData)this.deleteAgentInternalWithResponse(assistantId, requestOptions).getValue()).toObject(AgentDeletionStatus.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAgent(String assistantId) {
        AgentDeletionStatus deletionStatus = this.deleteAgentInternal(assistantId);
        if (deletionStatus == null || !deletionStatus.isDeleted()) {
            throw LOGGER.logExceptionAsWarning(new RuntimeException("Agent with ID '" + assistantId + "' could not be deleted."));
        }
    }

    PersistentAgentsAdministrationClient(PersistentAgentsAdministrationImpl serviceClient) {
        this.serviceClient = serviceClient;
    }
}

