/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.FilesClient;
import com.azure.ai.agents.persistent.MessagesClient;
import com.azure.ai.agents.persistent.PersistentAgentsAdministrationClient;
import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.RunsClient;
import com.azure.ai.agents.persistent.ThreadsClient;
import com.azure.ai.agents.persistent.VectorStoresClient;
import com.azure.ai.agents.persistent.implementation.PersistentAgentsClientImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateThreadAndRunRequest;
import com.azure.ai.agents.persistent.models.CreateThreadAndRunOptions;
import com.azure.ai.agents.persistent.models.ThreadRun;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;

@ServiceClient(builder=PersistentAgentsClientBuilder.class)
public final class PersistentAgentsClient {
    private final PersistentAgentsClientImpl serviceClient;

    PersistentAgentsClient(PersistentAgentsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    public PersistentAgentsAdministrationClient getPersistentAgentsAdministrationClient() {
        return new PersistentAgentsAdministrationClient(this.serviceClient.getPersistentAgentsAdministration());
    }

    public FilesClient getFilesClient() {
        return new FilesClient(this.serviceClient.getFiles());
    }

    public MessagesClient getMessagesClient() {
        return new MessagesClient(this.serviceClient.getMessages());
    }

    public RunsClient getRunsClient() {
        return new RunsClient(this.serviceClient.getRuns());
    }

    public ThreadsClient getThreadsClient() {
        return new ThreadsClient(this.serviceClient.getThreads());
    }

    public VectorStoresClient getVectorStoresClient() {
        return new VectorStoresClient(this.serviceClient.getVectorStores());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createThreadAndRunWithResponse(BinaryData createThreadAndRunRequest, RequestOptions requestOptions) {
        return this.serviceClient.createThreadAndRunWithResponse(createThreadAndRunRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun createThreadAndRun(CreateThreadAndRunOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        CreateThreadAndRunRequest createThreadAndRunRequestObj = new CreateThreadAndRunRequest(options.getAssistantId()).setThread(options.getThread()).setModel(options.getModel()).setInstructions(options.getInstructions()).setTools(options.getTools()).setToolResources(options.getToolResources()).setStream(options.isStream()).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setMaxPromptTokens(options.getMaxPromptTokens()).setMaxCompletionTokens(options.getMaxCompletionTokens()).setTruncationStrategy(options.getTruncationStrategy()).setToolChoice(options.getToolChoice()).setResponseFormat(options.getResponseFormat()).setParallelToolCalls(options.isParallelToolCalls()).setMetadata(options.getMetadata());
        BinaryData createThreadAndRunRequest = BinaryData.fromObject((Object)createThreadAndRunRequestObj);
        return (ThreadRun)((BinaryData)this.createThreadAndRunWithResponse(createThreadAndRunRequest, requestOptions).getValue()).toObject(ThreadRun.class);
    }
}

