/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.RunsImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateRunRequest;
import com.azure.ai.agents.persistent.implementation.models.SubmitToolOutputsToRunRequest;
import com.azure.ai.agents.persistent.implementation.models.UpdateRunRequest;
import com.azure.ai.agents.persistent.models.CreateRunOptions;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.PersistentAgentServerSentEvents;
import com.azure.ai.agents.persistent.models.RunAdditionalFieldList;
import com.azure.ai.agents.persistent.models.RunStep;
import com.azure.ai.agents.persistent.models.StreamUpdate;
import com.azure.ai.agents.persistent.models.ThreadRun;
import com.azure.ai.agents.persistent.models.ToolOutput;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PersistentAgentsClientBuilder.class, isAsync=true)
public final class RunsAsyncClient {
    private final RunsImpl serviceClient;

    RunsAsyncClient(RunsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createRunWithResponse(String threadId, BinaryData createRunRequest, RequestOptions requestOptions) {
        return this.serviceClient.createRunWithResponseAsync(threadId, createRunRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listRuns(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.listRunsAsync(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        return this.serviceClient.getRunWithResponseAsync(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateRunWithResponse(String threadId, String runId, BinaryData updateRunRequest, RequestOptions requestOptions) {
        return this.serviceClient.updateRunWithResponseAsync(threadId, runId, updateRunRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> submitToolOutputsToRunWithResponse(String threadId, String runId, BinaryData submitToolOutputsToRunRequest, RequestOptions requestOptions) {
        return this.serviceClient.submitToolOutputsToRunWithResponseAsync(threadId, runId, submitToolOutputsToRunRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> cancelRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        return this.serviceClient.cancelRunWithResponseAsync(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRunStepWithResponse(String threadId, String runId, String stepId, RequestOptions requestOptions) {
        return this.serviceClient.getRunStepWithResponseAsync(threadId, runId, stepId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listRunSteps(String threadId, String runId, RequestOptions requestOptions) {
        return this.serviceClient.listRunStepsAsync(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> createRun(CreateRunOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        String threadId = options.getThreadId();
        List<RunAdditionalFieldList> include = options.getInclude();
        CreateRunRequest createRunRequestObj = new CreateRunRequest(options.getAssistantId()).setModel(options.getModel()).setInstructions(options.getInstructions()).setAdditionalInstructions(options.getAdditionalInstructions()).setAdditionalMessages(options.getAdditionalMessages()).setTools(options.getTools()).setStream(options.isStream()).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setMaxPromptTokens(options.getMaxPromptTokens()).setMaxCompletionTokens(options.getMaxCompletionTokens()).setTruncationStrategy(options.getTruncationStrategy()).setToolChoice(options.getToolChoice()).setResponseFormat(options.getResponseFormat()).setParallelToolCalls(options.isParallelToolCalls()).setMetadata(options.getMetadata());
        BinaryData createRunRequest = BinaryData.fromObject((Object)createRunRequestObj);
        if (include != null) {
            requestOptions.addQueryParam("include[]", include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.createRunWithResponse(threadId, createRunRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ThreadRun> listRuns(String threadId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listRuns(threadId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ThreadRun> listRuns(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listRuns(threadId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> getRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRunWithResponse(threadId, runId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> updateRun(String threadId, String runId, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest updateRunRequestObj = new UpdateRunRequest().setMetadata(metadata);
        BinaryData updateRunRequest = BinaryData.fromObject((Object)updateRunRequestObj);
        return this.updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> updateRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest updateRunRequestObj = new UpdateRunRequest();
        BinaryData updateRunRequest = BinaryData.fromObject((Object)updateRunRequestObj);
        return this.updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> submitToolOutputsToRun(String threadId, String runId, List<ToolOutput> toolOutputs, Boolean stream) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest submitToolOutputsToRunRequestObj = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(stream);
        BinaryData submitToolOutputsToRunRequest = BinaryData.fromObject((Object)submitToolOutputsToRunRequestObj);
        return this.submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> submitToolOutputsToRun(String threadId, String runId, List<ToolOutput> toolOutputs) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest submitToolOutputsToRunRequestObj = new SubmitToolOutputsToRunRequest(toolOutputs);
        BinaryData submitToolOutputsToRunRequest = BinaryData.fromObject((Object)submitToolOutputsToRunRequestObj);
        return this.submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> cancelRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.cancelRunWithResponse(threadId, runId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunStep> getRunStep(String threadId, String runId, String stepId, List<RunAdditionalFieldList> include) {
        RequestOptions requestOptions = new RequestOptions();
        if (include != null) {
            requestOptions.addQueryParam("include[]", include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.getRunStepWithResponse(threadId, runId, stepId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (RunStep)protocolMethodData.toObject(RunStep.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunStep> getRunStep(String threadId, String runId, String stepId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRunStepWithResponse(threadId, runId, stepId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (RunStep)protocolMethodData.toObject(RunStep.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RunStep> listRunSteps(String threadId, String runId, List<RunAdditionalFieldList> include, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (include != null) {
            requestOptions.addQueryParam("include[]", include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listRunSteps(threadId, runId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (RunStep)protocolMethodData.toObject(RunStep.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RunStep> listRunSteps(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listRunSteps(threadId, runId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (RunStep)protocolMethodData.toObject(RunStep.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<StreamUpdate> createRunStreaming(CreateRunOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        String threadId = options.getThreadId();
        List<RunAdditionalFieldList> include = options.getInclude();
        CreateRunRequest createRunRequestObj = new CreateRunRequest(options.getAssistantId()).setModel(options.getModel()).setInstructions(options.getInstructions()).setAdditionalInstructions(options.getAdditionalInstructions()).setAdditionalMessages(options.getAdditionalMessages()).setTools(options.getTools()).setStream(true).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setMaxPromptTokens(options.getMaxPromptTokens()).setMaxCompletionTokens(options.getMaxCompletionTokens()).setTruncationStrategy(options.getTruncationStrategy()).setToolChoice(options.getToolChoice()).setResponseFormat(options.getResponseFormat()).setParallelToolCalls(options.isParallelToolCalls()).setMetadata(options.getMetadata());
        BinaryData createRunRequest = BinaryData.fromObject((Object)createRunRequestObj);
        if (include != null) {
            requestOptions.addQueryParam("include[]", include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.createRunWithResponse(threadId, createRunRequest, requestOptions).flatMapMany(response -> {
            PersistentAgentServerSentEvents eventStream = new PersistentAgentServerSentEvents((Flux<ByteBuffer>)((BinaryData)response.getValue()).toFluxByteBuffer());
            return eventStream.getEvents();
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<StreamUpdate> submitToolOutputsToRunStreaming(String threadId, String runId, List<ToolOutput> toolOutputs) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest submitToolOutputsToRunRequestObj = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(true);
        BinaryData submitToolOutputsToRunRequest = BinaryData.fromObject((Object)submitToolOutputsToRunRequestObj);
        return this.submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions).flatMapMany(response -> {
            PersistentAgentServerSentEvents eventStream = new PersistentAgentServerSentEvents((Flux<ByteBuffer>)((BinaryData)response.getValue()).toFluxByteBuffer());
            return eventStream.getEvents();
        });
    }
}

