/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.ThreadsImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateThreadRequest;
import com.azure.ai.agents.persistent.implementation.models.ThreadDeletionStatus;
import com.azure.ai.agents.persistent.implementation.models.UpdateThreadRequest;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.PersistentAgentThread;
import com.azure.ai.agents.persistent.models.ThreadMessageOptions;
import com.azure.ai.agents.persistent.models.ToolResources;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.util.List;
import java.util.Map;

@ServiceClient(builder=PersistentAgentsClientBuilder.class)
public final class ThreadsClient {
    private static final ClientLogger LOGGER = new ClientLogger(ThreadsClient.class);
    private final ThreadsImpl serviceClient;

    ThreadsClient(ThreadsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createThreadWithResponse(BinaryData createThreadRequest, RequestOptions requestOptions) {
        return this.serviceClient.createThreadWithResponse(createThreadRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listThreads(RequestOptions requestOptions) {
        return this.serviceClient.listThreads(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getThreadWithResponse(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.getThreadWithResponse(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateThreadWithResponse(String threadId, BinaryData updateThreadRequest, RequestOptions requestOptions) {
        return this.serviceClient.updateThreadWithResponse(threadId, updateThreadRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PersistentAgentThread createThread(List<ThreadMessageOptions> messages, ToolResources toolResources, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        CreateThreadRequest createThreadRequestObj = new CreateThreadRequest().setMessages(messages).setToolResources(toolResources).setMetadata(metadata);
        BinaryData createThreadRequest = BinaryData.fromObject((Object)createThreadRequestObj);
        return (PersistentAgentThread)((BinaryData)this.createThreadWithResponse(createThreadRequest, requestOptions).getValue()).toObject(PersistentAgentThread.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PersistentAgentThread createThread() {
        RequestOptions requestOptions = new RequestOptions();
        CreateThreadRequest createThreadRequestObj = new CreateThreadRequest();
        BinaryData createThreadRequest = BinaryData.fromObject((Object)createThreadRequestObj);
        return (PersistentAgentThread)((BinaryData)this.createThreadWithResponse(createThreadRequest, requestOptions).getValue()).toObject(PersistentAgentThread.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PersistentAgentThread> listThreads(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.serviceClient.listThreads(requestOptions).mapPage(bodyItemValue -> (PersistentAgentThread)bodyItemValue.toObject(PersistentAgentThread.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PersistentAgentThread> listThreads() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listThreads(requestOptions).mapPage(bodyItemValue -> (PersistentAgentThread)bodyItemValue.toObject(PersistentAgentThread.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PersistentAgentThread getThread(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return (PersistentAgentThread)((BinaryData)this.getThreadWithResponse(threadId, requestOptions).getValue()).toObject(PersistentAgentThread.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PersistentAgentThread updateThread(String threadId, ToolResources toolResources, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateThreadRequest updateThreadRequestObj = new UpdateThreadRequest().setToolResources(toolResources).setMetadata(metadata);
        BinaryData updateThreadRequest = BinaryData.fromObject((Object)updateThreadRequestObj);
        return (PersistentAgentThread)((BinaryData)this.updateThreadWithResponse(threadId, updateThreadRequest, requestOptions).getValue()).toObject(PersistentAgentThread.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PersistentAgentThread updateThread(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateThreadRequest updateThreadRequestObj = new UpdateThreadRequest();
        BinaryData updateThreadRequest = BinaryData.fromObject((Object)updateThreadRequestObj);
        return (PersistentAgentThread)((BinaryData)this.updateThreadWithResponse(threadId, updateThreadRequest, requestOptions).getValue()).toObject(PersistentAgentThread.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> deleteThreadInternalWithResponse(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.deleteThreadInternalWithResponse(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    ThreadDeletionStatus deleteThreadInternal(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadDeletionStatus)((BinaryData)this.deleteThreadInternalWithResponse(threadId, requestOptions).getValue()).toObject(ThreadDeletionStatus.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteThread(String threadId) {
        ThreadDeletionStatus deletionStatus = this.deleteThreadInternal(threadId);
        if (deletionStatus == null || !deletionStatus.isDeleted()) {
            throw LOGGER.logExceptionAsWarning(new RuntimeException("Thread with ID '" + threadId + "' could not be deleted."));
        }
    }
}

