/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.VectorStoresImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateVectorStoreFileBatchRequest;
import com.azure.ai.agents.persistent.implementation.models.CreateVectorStoreFileRequest;
import com.azure.ai.agents.persistent.implementation.models.CreateVectorStoreRequest;
import com.azure.ai.agents.persistent.implementation.models.ModifyVectorStoreRequest;
import com.azure.ai.agents.persistent.implementation.models.VectorStoreDeletionStatus;
import com.azure.ai.agents.persistent.implementation.models.VectorStoreFileDeletionStatus;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.VectorStore;
import com.azure.ai.agents.persistent.models.VectorStoreChunkingStrategyRequest;
import com.azure.ai.agents.persistent.models.VectorStoreConfiguration;
import com.azure.ai.agents.persistent.models.VectorStoreDataSource;
import com.azure.ai.agents.persistent.models.VectorStoreExpirationPolicy;
import com.azure.ai.agents.persistent.models.VectorStoreFile;
import com.azure.ai.agents.persistent.models.VectorStoreFileBatch;
import com.azure.ai.agents.persistent.models.VectorStoreFileStatusFilter;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PersistentAgentsClientBuilder.class, isAsync=true)
public final class VectorStoresAsyncClient {
    private final VectorStoresImpl serviceClient;

    VectorStoresAsyncClient(VectorStoresImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createVectorStoreWithResponse(BinaryData createVectorStoreRequest, RequestOptions requestOptions) {
        return this.serviceClient.createVectorStoreWithResponseAsync(createVectorStoreRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getVectorStoreWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        return this.serviceClient.getVectorStoreWithResponseAsync(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> modifyVectorStoreWithResponse(String vectorStoreId, BinaryData modifyVectorStoreRequest, RequestOptions requestOptions) {
        return this.serviceClient.modifyVectorStoreWithResponseAsync(vectorStoreId, modifyVectorStoreRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listVectorStores(RequestOptions requestOptions) {
        return this.serviceClient.listVectorStoresAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createVectorStoreFileWithResponse(String vectorStoreId, BinaryData createVectorStoreFileRequest, RequestOptions requestOptions) {
        return this.serviceClient.createVectorStoreFileWithResponseAsync(vectorStoreId, createVectorStoreFileRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getVectorStoreFileWithResponse(String vectorStoreId, String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getVectorStoreFileWithResponseAsync(vectorStoreId, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listVectorStoreFiles(String vectorStoreId, RequestOptions requestOptions) {
        return this.serviceClient.listVectorStoreFilesAsync(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createVectorStoreFileBatchWithResponse(String vectorStoreId, BinaryData createVectorStoreFileBatchRequest, RequestOptions requestOptions) {
        return this.serviceClient.createVectorStoreFileBatchWithResponseAsync(vectorStoreId, createVectorStoreFileBatchRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        return this.serviceClient.getVectorStoreFileBatchWithResponseAsync(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> cancelVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        return this.serviceClient.cancelVectorStoreFileBatchWithResponseAsync(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        return this.serviceClient.listVectorStoreFileBatchFilesAsync(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStore> createVectorStore(List<String> fileIds, String name, VectorStoreConfiguration storeConfiguration, VectorStoreExpirationPolicy expiresAfter, VectorStoreChunkingStrategyRequest chunkingStrategy, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreRequest createVectorStoreRequestObj = new CreateVectorStoreRequest().setFileIds(fileIds).setName(name).setStoreConfiguration(storeConfiguration).setExpiresAfter(expiresAfter).setChunkingStrategy(chunkingStrategy).setMetadata(metadata);
        BinaryData createVectorStoreRequest = BinaryData.fromObject((Object)createVectorStoreRequestObj);
        return this.createVectorStoreWithResponse(createVectorStoreRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStore> createVectorStore() {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreRequest createVectorStoreRequestObj = new CreateVectorStoreRequest();
        BinaryData createVectorStoreRequest = BinaryData.fromObject((Object)createVectorStoreRequestObj);
        return this.createVectorStoreWithResponse(createVectorStoreRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStore> getVectorStore(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getVectorStoreWithResponse(vectorStoreId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStore> modifyVectorStore(String vectorStoreId, String name, VectorStoreExpirationPolicy expiresAfter, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        ModifyVectorStoreRequest modifyVectorStoreRequestObj = new ModifyVectorStoreRequest().setName(name).setExpiresAfter(expiresAfter).setMetadata(metadata);
        BinaryData modifyVectorStoreRequest = BinaryData.fromObject((Object)modifyVectorStoreRequestObj);
        return this.modifyVectorStoreWithResponse(vectorStoreId, modifyVectorStoreRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStore> modifyVectorStore(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        ModifyVectorStoreRequest modifyVectorStoreRequestObj = new ModifyVectorStoreRequest();
        BinaryData modifyVectorStoreRequest = BinaryData.fromObject((Object)modifyVectorStoreRequestObj);
        return this.modifyVectorStoreWithResponse(vectorStoreId, modifyVectorStoreRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VectorStore> listVectorStores(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listVectorStores(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VectorStore> listVectorStores() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listVectorStores(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (VectorStore)protocolMethodData.toObject(VectorStore.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFile> createVectorStoreFile(String vectorStoreId, String fileId, VectorStoreDataSource dataSource, VectorStoreChunkingStrategyRequest chunkingStrategy) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileRequest createVectorStoreFileRequestObj = new CreateVectorStoreFileRequest().setFileId(fileId).setDataSource(dataSource).setChunkingStrategy(chunkingStrategy);
        BinaryData createVectorStoreFileRequest = BinaryData.fromObject((Object)createVectorStoreFileRequestObj);
        return this.createVectorStoreFileWithResponse(vectorStoreId, createVectorStoreFileRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFile> createVectorStoreFile(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileRequest createVectorStoreFileRequestObj = new CreateVectorStoreFileRequest();
        BinaryData createVectorStoreFileRequest = BinaryData.fromObject((Object)createVectorStoreFileRequestObj);
        return this.createVectorStoreFileWithResponse(vectorStoreId, createVectorStoreFileRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFile> getVectorStoreFile(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getVectorStoreFileWithResponse(vectorStoreId, fileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VectorStoreFile> listVectorStoreFiles(String vectorStoreId, VectorStoreFileStatusFilter filter, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (filter != null) {
            requestOptions.addQueryParam("filter", filter.toString(), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listVectorStoreFiles(vectorStoreId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VectorStoreFile> listVectorStoreFiles(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listVectorStoreFiles(vectorStoreId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFileBatch> createVectorStoreFileBatch(String vectorStoreId, List<String> fileIds, List<VectorStoreDataSource> dataSources, VectorStoreChunkingStrategyRequest chunkingStrategy) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileBatchRequest createVectorStoreFileBatchRequestObj = new CreateVectorStoreFileBatchRequest().setFileIds(fileIds).setDataSources(dataSources).setChunkingStrategy(chunkingStrategy);
        BinaryData createVectorStoreFileBatchRequest = BinaryData.fromObject((Object)createVectorStoreFileBatchRequestObj);
        return this.createVectorStoreFileBatchWithResponse(vectorStoreId, createVectorStoreFileBatchRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileBatch)protocolMethodData.toObject(VectorStoreFileBatch.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFileBatch> createVectorStoreFileBatch(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileBatchRequest createVectorStoreFileBatchRequestObj = new CreateVectorStoreFileBatchRequest();
        BinaryData createVectorStoreFileBatchRequest = BinaryData.fromObject((Object)createVectorStoreFileBatchRequestObj);
        return this.createVectorStoreFileBatchWithResponse(vectorStoreId, createVectorStoreFileBatchRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileBatch)protocolMethodData.toObject(VectorStoreFileBatch.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFileBatch> getVectorStoreFileBatch(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileBatch)protocolMethodData.toObject(VectorStoreFileBatch.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VectorStoreFileBatch> cancelVectorStoreFileBatch(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.cancelVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileBatch)protocolMethodData.toObject(VectorStoreFileBatch.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VectorStoreFile> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId, VectorStoreFileStatusFilter filter, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (filter != null) {
            requestOptions.addQueryParam("filter", filter.toString(), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listVectorStoreFileBatchFiles(vectorStoreId, batchId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VectorStoreFile> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listVectorStoreFileBatchFiles(vectorStoreId, batchId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (VectorStoreFile)protocolMethodData.toObject(VectorStoreFile.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> deleteVectorStoreInternalWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        return this.serviceClient.deleteVectorStoreInternalWithResponseAsync(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> deleteVectorStoreFileInternalWithResponse(String vectorStoreId, String fileId, RequestOptions requestOptions) {
        return this.serviceClient.deleteVectorStoreFileInternalWithResponseAsync(vectorStoreId, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<VectorStoreDeletionStatus> deleteVectorStoreInternal(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteVectorStoreInternalWithResponse(vectorStoreId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreDeletionStatus)protocolMethodData.toObject(VectorStoreDeletionStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<VectorStoreFileDeletionStatus> deleteVectorStoreFileInternal(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteVectorStoreFileInternalWithResponse(vectorStoreId, fileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (VectorStoreFileDeletionStatus)protocolMethodData.toObject(VectorStoreFileDeletionStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteVectorStoreFile(String vectorStoreId, String fileId) {
        Mono<VectorStoreFileDeletionStatus> deletionStatusMono = this.deleteVectorStoreFileInternal(vectorStoreId, fileId);
        return deletionStatusMono.flatMap(deletionStatus -> {
            if (deletionStatus == null || !deletionStatus.isDeleted()) {
                return Mono.error((Throwable)new RuntimeException("VectorStore file with ID '" + fileId + "' could not be deleted."));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteVectorStore(String vectorStoreId) {
        Mono<VectorStoreDeletionStatus> deletionStatusMono = this.deleteVectorStoreInternal(vectorStoreId);
        return deletionStatusMono.flatMap(deletionStatus -> {
            if (deletionStatus == null || !deletionStatus.isDeleted()) {
                return Mono.error((Throwable)new RuntimeException("VectorStore with ID '" + vectorStoreId + "' could not be deleted."));
            }
            return Mono.empty();
        });
    }
}

