/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.VectorStoresImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateVectorStoreFileBatchRequest;
import com.azure.ai.agents.persistent.implementation.models.CreateVectorStoreFileRequest;
import com.azure.ai.agents.persistent.implementation.models.CreateVectorStoreRequest;
import com.azure.ai.agents.persistent.implementation.models.ModifyVectorStoreRequest;
import com.azure.ai.agents.persistent.implementation.models.VectorStoreDeletionStatus;
import com.azure.ai.agents.persistent.implementation.models.VectorStoreFileDeletionStatus;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.VectorStore;
import com.azure.ai.agents.persistent.models.VectorStoreChunkingStrategyRequest;
import com.azure.ai.agents.persistent.models.VectorStoreConfiguration;
import com.azure.ai.agents.persistent.models.VectorStoreDataSource;
import com.azure.ai.agents.persistent.models.VectorStoreExpirationPolicy;
import com.azure.ai.agents.persistent.models.VectorStoreFile;
import com.azure.ai.agents.persistent.models.VectorStoreFileBatch;
import com.azure.ai.agents.persistent.models.VectorStoreFileStatusFilter;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.util.List;
import java.util.Map;

@ServiceClient(builder=PersistentAgentsClientBuilder.class)
public final class VectorStoresClient {
    private static final ClientLogger LOGGER = new ClientLogger(VectorStoresClient.class);
    private final VectorStoresImpl serviceClient;

    VectorStoresClient(VectorStoresImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createVectorStoreWithResponse(BinaryData createVectorStoreRequest, RequestOptions requestOptions) {
        return this.serviceClient.createVectorStoreWithResponse(createVectorStoreRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getVectorStoreWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        return this.serviceClient.getVectorStoreWithResponse(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> modifyVectorStoreWithResponse(String vectorStoreId, BinaryData modifyVectorStoreRequest, RequestOptions requestOptions) {
        return this.serviceClient.modifyVectorStoreWithResponse(vectorStoreId, modifyVectorStoreRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listVectorStores(RequestOptions requestOptions) {
        return this.serviceClient.listVectorStores(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createVectorStoreFileWithResponse(String vectorStoreId, BinaryData createVectorStoreFileRequest, RequestOptions requestOptions) {
        return this.serviceClient.createVectorStoreFileWithResponse(vectorStoreId, createVectorStoreFileRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getVectorStoreFileWithResponse(String vectorStoreId, String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getVectorStoreFileWithResponse(vectorStoreId, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listVectorStoreFiles(String vectorStoreId, RequestOptions requestOptions) {
        return this.serviceClient.listVectorStoreFiles(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createVectorStoreFileBatchWithResponse(String vectorStoreId, BinaryData createVectorStoreFileBatchRequest, RequestOptions requestOptions) {
        return this.serviceClient.createVectorStoreFileBatchWithResponse(vectorStoreId, createVectorStoreFileBatchRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        return this.serviceClient.getVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> cancelVectorStoreFileBatchWithResponse(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        return this.serviceClient.cancelVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId, RequestOptions requestOptions) {
        return this.serviceClient.listVectorStoreFileBatchFiles(vectorStoreId, batchId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStore createVectorStore(List<String> fileIds, String name, VectorStoreConfiguration storeConfiguration, VectorStoreExpirationPolicy expiresAfter, VectorStoreChunkingStrategyRequest chunkingStrategy, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreRequest createVectorStoreRequestObj = new CreateVectorStoreRequest().setFileIds(fileIds).setName(name).setStoreConfiguration(storeConfiguration).setExpiresAfter(expiresAfter).setChunkingStrategy(chunkingStrategy).setMetadata(metadata);
        BinaryData createVectorStoreRequest = BinaryData.fromObject((Object)createVectorStoreRequestObj);
        return (VectorStore)((BinaryData)this.createVectorStoreWithResponse(createVectorStoreRequest, requestOptions).getValue()).toObject(VectorStore.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStore createVectorStore() {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreRequest createVectorStoreRequestObj = new CreateVectorStoreRequest();
        BinaryData createVectorStoreRequest = BinaryData.fromObject((Object)createVectorStoreRequestObj);
        return (VectorStore)((BinaryData)this.createVectorStoreWithResponse(createVectorStoreRequest, requestOptions).getValue()).toObject(VectorStore.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStore getVectorStore(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStore)((BinaryData)this.getVectorStoreWithResponse(vectorStoreId, requestOptions).getValue()).toObject(VectorStore.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStore modifyVectorStore(String vectorStoreId, String name, VectorStoreExpirationPolicy expiresAfter, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        ModifyVectorStoreRequest modifyVectorStoreRequestObj = new ModifyVectorStoreRequest().setName(name).setExpiresAfter(expiresAfter).setMetadata(metadata);
        BinaryData modifyVectorStoreRequest = BinaryData.fromObject((Object)modifyVectorStoreRequestObj);
        return (VectorStore)((BinaryData)this.modifyVectorStoreWithResponse(vectorStoreId, modifyVectorStoreRequest, requestOptions).getValue()).toObject(VectorStore.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStore modifyVectorStore(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        ModifyVectorStoreRequest modifyVectorStoreRequestObj = new ModifyVectorStoreRequest();
        BinaryData modifyVectorStoreRequest = BinaryData.fromObject((Object)modifyVectorStoreRequestObj);
        return (VectorStore)((BinaryData)this.modifyVectorStoreWithResponse(vectorStoreId, modifyVectorStoreRequest, requestOptions).getValue()).toObject(VectorStore.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VectorStore> listVectorStores(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.serviceClient.listVectorStores(requestOptions).mapPage(bodyItemValue -> (VectorStore)bodyItemValue.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VectorStore> listVectorStores() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listVectorStores(requestOptions).mapPage(bodyItemValue -> (VectorStore)bodyItemValue.toObject(VectorStore.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFile createVectorStoreFile(String vectorStoreId, String fileId, VectorStoreDataSource dataSource, VectorStoreChunkingStrategyRequest chunkingStrategy) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileRequest createVectorStoreFileRequestObj = new CreateVectorStoreFileRequest().setFileId(fileId).setDataSource(dataSource).setChunkingStrategy(chunkingStrategy);
        BinaryData createVectorStoreFileRequest = BinaryData.fromObject((Object)createVectorStoreFileRequestObj);
        return (VectorStoreFile)((BinaryData)this.createVectorStoreFileWithResponse(vectorStoreId, createVectorStoreFileRequest, requestOptions).getValue()).toObject(VectorStoreFile.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFile createVectorStoreFile(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileRequest createVectorStoreFileRequestObj = new CreateVectorStoreFileRequest();
        BinaryData createVectorStoreFileRequest = BinaryData.fromObject((Object)createVectorStoreFileRequestObj);
        return (VectorStoreFile)((BinaryData)this.createVectorStoreFileWithResponse(vectorStoreId, createVectorStoreFileRequest, requestOptions).getValue()).toObject(VectorStoreFile.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFile getVectorStoreFile(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreFile)((BinaryData)this.getVectorStoreFileWithResponse(vectorStoreId, fileId, requestOptions).getValue()).toObject(VectorStoreFile.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VectorStoreFile> listVectorStoreFiles(String vectorStoreId, VectorStoreFileStatusFilter filter, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (filter != null) {
            requestOptions.addQueryParam("filter", filter.toString(), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.serviceClient.listVectorStoreFiles(vectorStoreId, requestOptions).mapPage(bodyItemValue -> (VectorStoreFile)bodyItemValue.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VectorStoreFile> listVectorStoreFiles(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listVectorStoreFiles(vectorStoreId, requestOptions).mapPage(bodyItemValue -> (VectorStoreFile)bodyItemValue.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFileBatch createVectorStoreFileBatch(String vectorStoreId, List<String> fileIds, List<VectorStoreDataSource> dataSources, VectorStoreChunkingStrategyRequest chunkingStrategy) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileBatchRequest createVectorStoreFileBatchRequestObj = new CreateVectorStoreFileBatchRequest().setFileIds(fileIds).setDataSources(dataSources).setChunkingStrategy(chunkingStrategy);
        BinaryData createVectorStoreFileBatchRequest = BinaryData.fromObject((Object)createVectorStoreFileBatchRequestObj);
        return (VectorStoreFileBatch)((BinaryData)this.createVectorStoreFileBatchWithResponse(vectorStoreId, createVectorStoreFileBatchRequest, requestOptions).getValue()).toObject(VectorStoreFileBatch.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFileBatch createVectorStoreFileBatch(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        CreateVectorStoreFileBatchRequest createVectorStoreFileBatchRequestObj = new CreateVectorStoreFileBatchRequest();
        BinaryData createVectorStoreFileBatchRequest = BinaryData.fromObject((Object)createVectorStoreFileBatchRequestObj);
        return (VectorStoreFileBatch)((BinaryData)this.createVectorStoreFileBatchWithResponse(vectorStoreId, createVectorStoreFileBatchRequest, requestOptions).getValue()).toObject(VectorStoreFileBatch.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFileBatch getVectorStoreFileBatch(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreFileBatch)((BinaryData)this.getVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions).getValue()).toObject(VectorStoreFileBatch.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public VectorStoreFileBatch cancelVectorStoreFileBatch(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreFileBatch)((BinaryData)this.cancelVectorStoreFileBatchWithResponse(vectorStoreId, batchId, requestOptions).getValue()).toObject(VectorStoreFileBatch.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VectorStoreFile> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId, VectorStoreFileStatusFilter filter, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (filter != null) {
            requestOptions.addQueryParam("filter", filter.toString(), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.serviceClient.listVectorStoreFileBatchFiles(vectorStoreId, batchId, requestOptions).mapPage(bodyItemValue -> (VectorStoreFile)bodyItemValue.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VectorStoreFile> listVectorStoreFileBatchFiles(String vectorStoreId, String batchId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listVectorStoreFileBatchFiles(vectorStoreId, batchId, requestOptions).mapPage(bodyItemValue -> (VectorStoreFile)bodyItemValue.toObject(VectorStoreFile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> deleteVectorStoreInternalWithResponse(String vectorStoreId, RequestOptions requestOptions) {
        return this.serviceClient.deleteVectorStoreInternalWithResponse(vectorStoreId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> deleteVectorStoreFileInternalWithResponse(String vectorStoreId, String fileId, RequestOptions requestOptions) {
        return this.serviceClient.deleteVectorStoreFileInternalWithResponse(vectorStoreId, fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    VectorStoreDeletionStatus deleteVectorStoreInternal(String vectorStoreId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreDeletionStatus)((BinaryData)this.deleteVectorStoreInternalWithResponse(vectorStoreId, requestOptions).getValue()).toObject(VectorStoreDeletionStatus.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    VectorStoreFileDeletionStatus deleteVectorStoreFileInternal(String vectorStoreId, String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (VectorStoreFileDeletionStatus)((BinaryData)this.deleteVectorStoreFileInternalWithResponse(vectorStoreId, fileId, requestOptions).getValue()).toObject(VectorStoreFileDeletionStatus.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteVectorStoreFile(String vectorStoreId, String fileId) {
        VectorStoreFileDeletionStatus deletionStatus = this.deleteVectorStoreFileInternal(vectorStoreId, fileId);
        if (deletionStatus == null || !deletionStatus.isDeleted()) {
            throw LOGGER.logExceptionAsWarning(new RuntimeException("VectorStore file with ID '" + fileId + "' could not be deleted."));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteVectorStore(String vectorStoreId) {
        VectorStoreDeletionStatus deletionStatus = this.deleteVectorStoreInternal(vectorStoreId);
        if (deletionStatus == null || !deletionStatus.isDeleted()) {
            throw LOGGER.logExceptionAsWarning(new RuntimeException("VectorStore with ID '" + vectorStoreId + "' could not be deleted."));
        }
    }
}

