/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.implementation;

import com.azure.ai.agents.persistent.PersistentAgentsServiceVersion;
import com.azure.ai.agents.persistent.implementation.FilesImpl;
import com.azure.ai.agents.persistent.implementation.MessagesImpl;
import com.azure.ai.agents.persistent.implementation.PersistentAgentsAdministrationImpl;
import com.azure.ai.agents.persistent.implementation.RunsImpl;
import com.azure.ai.agents.persistent.implementation.ThreadsImpl;
import com.azure.ai.agents.persistent.implementation.VectorStoresImpl;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class PersistentAgentsClientImpl {
    private final PersistentAgentsClientService service;
    private final String endpoint;
    private final PersistentAgentsServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public PersistentAgentsServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public PersistentAgentsClientImpl(String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public PersistentAgentsClientImpl(HttpPipeline httpPipeline, String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public PersistentAgentsClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (PersistentAgentsClientService)RestProxy.create(PersistentAgentsClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createThreadAndRunWithResponseAsync(BinaryData createThreadAndRunRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createThreadAndRun(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", "application/json", createThreadAndRunRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createThreadAndRunWithResponse(BinaryData createThreadAndRunRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createThreadAndRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", "application/json", createThreadAndRunRequest, requestOptions, Context.NONE);
    }

    public PersistentAgentsAdministrationImpl getPersistentAgentsAdministration() {
        return new PersistentAgentsAdministrationImpl(this.httpPipeline, this.serializerAdapter, this.endpoint, this.serviceVersion);
    }

    public FilesImpl getFiles() {
        return new FilesImpl(this.httpPipeline, this.serializerAdapter, this.endpoint, this.serviceVersion);
    }

    public MessagesImpl getMessages() {
        return new MessagesImpl(this.httpPipeline, this.serializerAdapter, this.endpoint, this.serviceVersion);
    }

    public RunsImpl getRuns() {
        return new RunsImpl(this.httpPipeline, this.serializerAdapter, this.endpoint, this.serviceVersion);
    }

    public ThreadsImpl getThreads() {
        return new ThreadsImpl(this.httpPipeline, this.serializerAdapter, this.endpoint, this.serviceVersion);
    }

    public VectorStoresImpl getVectorStores() {
        return new VectorStoresImpl(this.httpPipeline, this.serializerAdapter, this.endpoint, this.serviceVersion);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="PersistentAgentsClient")
    public static interface PersistentAgentsClientService {
        @Post(value="/threads/runs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createThreadAndRun(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);

        @Post(value="/threads/runs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createThreadAndRunSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Content-Type") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") BinaryData var5, RequestOptions var6, Context var7);
    }
}

