/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.implementation;

import com.azure.ai.agents.persistent.PersistentAgentsServiceVersion;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class RunsImpl {
    private final RunsService service;
    private final String endpoint;
    private final PersistentAgentsServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public PersistentAgentsServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public RunsImpl(String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public RunsImpl(HttpPipeline httpPipeline, String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public RunsImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, PersistentAgentsServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (RunsService)RestProxy.create(RunsService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createRunWithResponseAsync(String threadId, BinaryData createRunRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRun(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, "application/json", "application/json", createRunRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createRunWithResponse(String threadId, BinaryData createRunRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, "application/json", "application/json", createRunRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listRunsSinglePageAsync(String threadId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRuns(this.getEndpoint(), threadId, this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "data"), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listRunsAsync(String threadId, RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listRunsSinglePageAsync(threadId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listRunsSinglePage(String threadId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listRunsSync(this.getEndpoint(), threadId, this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "data"), null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listRuns(String threadId, RequestOptions requestOptions) {
        return new PagedIterable(() -> this.listRunsSinglePage(threadId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRunWithResponseAsync(String threadId, String runId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRun(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateRunWithResponseAsync(String threadId, String runId, BinaryData updateRunRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateRun(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, "application/json", "application/json", updateRunRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateRunWithResponse(String threadId, String runId, BinaryData updateRunRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, "application/json", "application/json", updateRunRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> submitToolOutputsToRunWithResponseAsync(String threadId, String runId, BinaryData submitToolOutputsToRunRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.submitToolOutputsToRun(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, "application/json", "application/json", submitToolOutputsToRunRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> submitToolOutputsToRunWithResponse(String threadId, String runId, BinaryData submitToolOutputsToRunRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.submitToolOutputsToRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, "application/json", "application/json", submitToolOutputsToRunRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> cancelRunWithResponseAsync(String threadId, String runId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelRun(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> cancelRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.cancelRunSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listRunStepsSinglePageAsync(String threadId, String runId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRunSteps(this.getEndpoint(), threadId, runId, this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "data"), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listRunStepsAsync(String threadId, String runId, RequestOptions requestOptions) {
        return new PagedFlux(() -> this.listRunStepsSinglePageAsync(threadId, runId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listRunStepsSinglePage(String threadId, String runId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listRunStepsSync(this.getEndpoint(), threadId, runId, this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "data"), null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listRunSteps(String threadId, String runId, RequestOptions requestOptions) {
        return new PagedIterable(() -> this.listRunStepsSinglePage(threadId, runId, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRunStepWithResponseAsync(String threadId, String runId, String stepId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRunStep(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, stepId, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRunStepWithResponse(String threadId, String runId, String stepId, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getRunStepSync(this.getEndpoint(), this.getServiceVersion().getVersion(), threadId, runId, stepId, "application/json", requestOptions, Context.NONE);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="Runs")
    public static interface RunsService {
        @Post(value="/threads/{threadId}/runs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createRun(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/threads/{threadId}/runs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createRunSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @HeaderParam(value="Content-Type") String var4, @HeaderParam(value="Accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Get(value="/threads/{threadId}/runs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listRuns(@HostParam(value="endpoint") String var1, @PathParam(value="threadId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/threads/{threadId}/runs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listRunsSync(@HostParam(value="endpoint") String var1, @PathParam(value="threadId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/threads/{threadId}/runs/{runId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getRun(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/threads/{threadId}/runs/{runId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getRunSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/threads/{threadId}/runs/{runId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> updateRun(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/threads/{threadId}/runs/{runId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> updateRunSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/threads/{threadId}/runs/{runId}/submit_tool_outputs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> submitToolOutputsToRun(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/threads/{threadId}/runs/{runId}/submit_tool_outputs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> submitToolOutputsToRunSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @HeaderParam(value="Content-Type") String var5, @HeaderParam(value="Accept") String var6, @BodyParam(value="application/json") BinaryData var7, RequestOptions var8, Context var9);

        @Post(value="/threads/{threadId}/runs/{runId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> cancelRun(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/threads/{threadId}/runs/{runId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> cancelRunSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/threads/{threadId}/runs/{runId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listRunSteps(@HostParam(value="endpoint") String var1, @PathParam(value="threadId") String var2, @PathParam(value="runId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/threads/{threadId}/runs/{runId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listRunStepsSync(@HostParam(value="endpoint") String var1, @PathParam(value="threadId") String var2, @PathParam(value="runId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/threads/{threadId}/runs/{runId}/steps/{stepId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getRunStep(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @PathParam(value="stepId") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/threads/{threadId}/runs/{runId}/steps/{stepId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getRunStepSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="threadId") String var3, @PathParam(value="runId") String var4, @PathParam(value="stepId") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);
    }
}

