/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.ThreadMessageOptions;
import com.azure.ai.agents.persistent.models.ToolDefinition;
import com.azure.ai.agents.persistent.models.TruncationObject;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CreateRunRequest
implements JsonSerializable<CreateRunRequest> {
    private final String assistantId;
    private String model;
    private String instructions;
    private String additionalInstructions;
    private List<ThreadMessageOptions> additionalMessages;
    private List<ToolDefinition> tools;
    private Boolean stream;
    private Double temperature;
    private Double topP;
    private Integer maxPromptTokens;
    private Integer maxCompletionTokens;
    private TruncationObject truncationStrategy;
    private BinaryData toolChoice;
    private BinaryData responseFormat;
    private Boolean parallelToolCalls;
    private Map<String, String> metadata;

    public CreateRunRequest(String assistantId) {
        this.assistantId = assistantId;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getModel() {
        return this.model;
    }

    public CreateRunRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public CreateRunRequest setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    public String getAdditionalInstructions() {
        return this.additionalInstructions;
    }

    public CreateRunRequest setAdditionalInstructions(String additionalInstructions) {
        this.additionalInstructions = additionalInstructions;
        return this;
    }

    public List<ThreadMessageOptions> getAdditionalMessages() {
        return this.additionalMessages;
    }

    public CreateRunRequest setAdditionalMessages(List<ThreadMessageOptions> additionalMessages) {
        this.additionalMessages = additionalMessages;
        return this;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public CreateRunRequest setTools(List<ToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public Boolean isStream() {
        return this.stream;
    }

    public CreateRunRequest setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public CreateRunRequest setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public CreateRunRequest setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    public CreateRunRequest setMaxPromptTokens(Integer maxPromptTokens) {
        this.maxPromptTokens = maxPromptTokens;
        return this;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public CreateRunRequest setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
        return this;
    }

    public TruncationObject getTruncationStrategy() {
        return this.truncationStrategy;
    }

    public CreateRunRequest setTruncationStrategy(TruncationObject truncationStrategy) {
        this.truncationStrategy = truncationStrategy;
        return this;
    }

    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    public CreateRunRequest setToolChoice(BinaryData toolChoice) {
        this.toolChoice = toolChoice;
        return this;
    }

    public BinaryData getResponseFormat() {
        return this.responseFormat;
    }

    public CreateRunRequest setResponseFormat(BinaryData responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public Boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public CreateRunRequest setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CreateRunRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeStringField("additional_instructions", this.additionalInstructions);
        jsonWriter.writeArrayField("additional_messages", this.additionalMessages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeNumberField("max_prompt_tokens", (Number)this.maxPromptTokens);
        jsonWriter.writeNumberField("max_completion_tokens", (Number)this.maxCompletionTokens);
        jsonWriter.writeJsonField("truncation_strategy", (JsonSerializable)this.truncationStrategy);
        if (this.toolChoice != null) {
            jsonWriter.writeFieldName("tool_choice");
            this.toolChoice.writeTo(jsonWriter);
        }
        if (this.responseFormat != null) {
            jsonWriter.writeFieldName("response_format");
            this.responseFormat.writeTo(jsonWriter);
        }
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CreateRunRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateRunRequest)jsonReader.readObject(reader -> {
            String assistantId = null;
            String model = null;
            String instructions = null;
            String additionalInstructions = null;
            List additionalMessages = null;
            List tools = null;
            Boolean stream = null;
            Double temperature = null;
            Double topP = null;
            Integer maxPromptTokens = null;
            Integer maxCompletionTokens = null;
            TruncationObject truncationStrategy = null;
            BinaryData toolChoice = null;
            BinaryData responseFormat = null;
            Boolean parallelToolCalls = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                    continue;
                }
                if ("additional_instructions".equals(fieldName)) {
                    additionalInstructions = reader.getString();
                    continue;
                }
                if ("additional_messages".equals(fieldName)) {
                    additionalMessages = reader.readArray(reader1 -> ThreadMessageOptions.fromJson(reader1));
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("max_prompt_tokens".equals(fieldName)) {
                    maxPromptTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("max_completion_tokens".equals(fieldName)) {
                    maxCompletionTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("truncation_strategy".equals(fieldName)) {
                    truncationStrategy = TruncationObject.fromJson(reader);
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            CreateRunRequest deserializedCreateRunRequest = new CreateRunRequest(assistantId);
            deserializedCreateRunRequest.model = model;
            deserializedCreateRunRequest.instructions = instructions;
            deserializedCreateRunRequest.additionalInstructions = additionalInstructions;
            deserializedCreateRunRequest.additionalMessages = additionalMessages;
            deserializedCreateRunRequest.tools = tools;
            deserializedCreateRunRequest.stream = stream;
            deserializedCreateRunRequest.temperature = temperature;
            deserializedCreateRunRequest.topP = topP;
            deserializedCreateRunRequest.maxPromptTokens = maxPromptTokens;
            deserializedCreateRunRequest.maxCompletionTokens = maxCompletionTokens;
            deserializedCreateRunRequest.truncationStrategy = truncationStrategy;
            deserializedCreateRunRequest.toolChoice = toolChoice;
            deserializedCreateRunRequest.responseFormat = responseFormat;
            deserializedCreateRunRequest.parallelToolCalls = parallelToolCalls;
            deserializedCreateRunRequest.metadata = metadata;
            return deserializedCreateRunRequest;
        });
    }
}

