/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.VectorStoreChunkingStrategyRequest;
import com.azure.ai.agents.persistent.models.VectorStoreDataSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CreateVectorStoreFileRequest
implements JsonSerializable<CreateVectorStoreFileRequest> {
    private String fileId;
    private VectorStoreDataSource dataSource;
    private VectorStoreChunkingStrategyRequest chunkingStrategy;

    public String getFileId() {
        return this.fileId;
    }

    public CreateVectorStoreFileRequest setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public VectorStoreDataSource getDataSource() {
        return this.dataSource;
    }

    public CreateVectorStoreFileRequest setDataSource(VectorStoreDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public VectorStoreChunkingStrategyRequest getChunkingStrategy() {
        return this.chunkingStrategy;
    }

    public CreateVectorStoreFileRequest setChunkingStrategy(VectorStoreChunkingStrategyRequest chunkingStrategy) {
        this.chunkingStrategy = chunkingStrategy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeJsonField("data_source", (JsonSerializable)this.dataSource);
        jsonWriter.writeJsonField("chunking_strategy", (JsonSerializable)this.chunkingStrategy);
        return jsonWriter.writeEndObject();
    }

    public static CreateVectorStoreFileRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateVectorStoreFileRequest)jsonReader.readObject(reader -> {
            CreateVectorStoreFileRequest deserializedCreateVectorStoreFileRequest = new CreateVectorStoreFileRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    deserializedCreateVectorStoreFileRequest.fileId = reader.getString();
                    continue;
                }
                if ("data_source".equals(fieldName)) {
                    deserializedCreateVectorStoreFileRequest.dataSource = VectorStoreDataSource.fromJson(reader);
                    continue;
                }
                if ("chunking_strategy".equals(fieldName)) {
                    deserializedCreateVectorStoreFileRequest.chunkingStrategy = VectorStoreChunkingStrategyRequest.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreateVectorStoreFileRequest;
        });
    }
}

