/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.VectorStoreChunkingStrategyRequest;
import com.azure.ai.agents.persistent.models.VectorStoreConfiguration;
import com.azure.ai.agents.persistent.models.VectorStoreExpirationPolicy;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CreateVectorStoreRequest
implements JsonSerializable<CreateVectorStoreRequest> {
    private List<String> fileIds;
    private String name;
    private VectorStoreConfiguration storeConfiguration;
    private VectorStoreExpirationPolicy expiresAfter;
    private VectorStoreChunkingStrategyRequest chunkingStrategy;
    private Map<String, String> metadata;

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public CreateVectorStoreRequest setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CreateVectorStoreRequest setName(String name) {
        this.name = name;
        return this;
    }

    public VectorStoreConfiguration getStoreConfiguration() {
        return this.storeConfiguration;
    }

    public CreateVectorStoreRequest setStoreConfiguration(VectorStoreConfiguration storeConfiguration) {
        this.storeConfiguration = storeConfiguration;
        return this;
    }

    public VectorStoreExpirationPolicy getExpiresAfter() {
        return this.expiresAfter;
    }

    public CreateVectorStoreRequest setExpiresAfter(VectorStoreExpirationPolicy expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    public VectorStoreChunkingStrategyRequest getChunkingStrategy() {
        return this.chunkingStrategy;
    }

    public CreateVectorStoreRequest setChunkingStrategy(VectorStoreChunkingStrategyRequest chunkingStrategy) {
        this.chunkingStrategy = chunkingStrategy;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CreateVectorStoreRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("file_ids", this.fileIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.storeConfiguration);
        jsonWriter.writeJsonField("expires_after", (JsonSerializable)this.expiresAfter);
        jsonWriter.writeJsonField("chunking_strategy", (JsonSerializable)this.chunkingStrategy);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CreateVectorStoreRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateVectorStoreRequest)jsonReader.readObject(reader -> {
            CreateVectorStoreRequest deserializedCreateVectorStoreRequest = new CreateVectorStoreRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_ids".equals(fieldName)) {
                    List fileIds;
                    deserializedCreateVectorStoreRequest.fileIds = fileIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCreateVectorStoreRequest.name = reader.getString();
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedCreateVectorStoreRequest.storeConfiguration = VectorStoreConfiguration.fromJson(reader);
                    continue;
                }
                if ("expires_after".equals(fieldName)) {
                    deserializedCreateVectorStoreRequest.expiresAfter = VectorStoreExpirationPolicy.fromJson(reader);
                    continue;
                }
                if ("chunking_strategy".equals(fieldName)) {
                    deserializedCreateVectorStoreRequest.chunkingStrategy = VectorStoreChunkingStrategyRequest.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedCreateVectorStoreRequest.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreateVectorStoreRequest;
        });
    }
}

