/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.VectorStoreExpirationPolicy;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class ModifyVectorStoreRequest
implements JsonSerializable<ModifyVectorStoreRequest> {
    private String name;
    private VectorStoreExpirationPolicy expiresAfter;
    private Map<String, String> metadata;

    public String getName() {
        return this.name;
    }

    public ModifyVectorStoreRequest setName(String name) {
        this.name = name;
        return this;
    }

    public VectorStoreExpirationPolicy getExpiresAfter() {
        return this.expiresAfter;
    }

    public ModifyVectorStoreRequest setExpiresAfter(VectorStoreExpirationPolicy expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ModifyVectorStoreRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("expires_after", (JsonSerializable)this.expiresAfter);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ModifyVectorStoreRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ModifyVectorStoreRequest)jsonReader.readObject(reader -> {
            ModifyVectorStoreRequest deserializedModifyVectorStoreRequest = new ModifyVectorStoreRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedModifyVectorStoreRequest.name = reader.getString();
                    continue;
                }
                if ("expires_after".equals(fieldName)) {
                    deserializedModifyVectorStoreRequest.expiresAfter = VectorStoreExpirationPolicy.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedModifyVectorStoreRequest.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModifyVectorStoreRequest;
        });
    }
}

