/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.ToolOutput;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class SubmitToolOutputsToRunRequest
implements JsonSerializable<SubmitToolOutputsToRunRequest> {
    private final List<ToolOutput> toolOutputs;
    private Boolean stream;

    public SubmitToolOutputsToRunRequest(List<ToolOutput> toolOutputs) {
        this.toolOutputs = toolOutputs;
    }

    public List<ToolOutput> getToolOutputs() {
        return this.toolOutputs;
    }

    public Boolean isStream() {
        return this.stream;
    }

    public SubmitToolOutputsToRunRequest setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tool_outputs", this.toolOutputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("stream", this.stream);
        return jsonWriter.writeEndObject();
    }

    public static SubmitToolOutputsToRunRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SubmitToolOutputsToRunRequest)jsonReader.readObject(reader -> {
            List toolOutputs = null;
            Boolean stream = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tool_outputs".equals(fieldName)) {
                    toolOutputs = reader.readArray(reader1 -> ToolOutput.fromJson(reader1));
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            SubmitToolOutputsToRunRequest deserializedSubmitToolOutputsToRunRequest = new SubmitToolOutputsToRunRequest(toolOutputs);
            deserializedSubmitToolOutputsToRunRequest.stream = stream;
            return deserializedSubmitToolOutputsToRunRequest;
        });
    }
}

