/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.ToolDefinition;
import com.azure.ai.agents.persistent.models.ToolResources;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class UpdateAgentRequest
implements JsonSerializable<UpdateAgentRequest> {
    private String model;
    private String name;
    private String description;
    private String instructions;
    private List<ToolDefinition> tools;
    private ToolResources toolResources;
    private Double temperature;
    private Double topP;
    private BinaryData responseFormat;
    private Map<String, String> metadata;

    public String getModel() {
        return this.model;
    }

    public UpdateAgentRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public UpdateAgentRequest setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateAgentRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public UpdateAgentRequest setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public UpdateAgentRequest setTools(List<ToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public ToolResources getToolResources() {
        return this.toolResources;
    }

    public UpdateAgentRequest setToolResources(ToolResources toolResources) {
        this.toolResources = toolResources;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public UpdateAgentRequest setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public UpdateAgentRequest setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public BinaryData getResponseFormat() {
        return this.responseFormat;
    }

    public UpdateAgentRequest setResponseFormat(BinaryData responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public UpdateAgentRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("tool_resources", (JsonSerializable)this.toolResources);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        if (this.responseFormat != null) {
            jsonWriter.writeFieldName("response_format");
            this.responseFormat.writeTo(jsonWriter);
        }
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static UpdateAgentRequest fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateAgentRequest)jsonReader.readObject(reader -> {
            UpdateAgentRequest deserializedUpdateAgentRequest = new UpdateAgentRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model".equals(fieldName)) {
                    deserializedUpdateAgentRequest.model = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUpdateAgentRequest.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedUpdateAgentRequest.description = reader.getString();
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    deserializedUpdateAgentRequest.instructions = reader.getString();
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    List tools;
                    deserializedUpdateAgentRequest.tools = tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("tool_resources".equals(fieldName)) {
                    deserializedUpdateAgentRequest.toolResources = ToolResources.fromJson(reader);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    deserializedUpdateAgentRequest.temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    deserializedUpdateAgentRequest.topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    deserializedUpdateAgentRequest.responseFormat = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedUpdateAgentRequest.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateAgentRequest;
        });
    }
}

