/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.AzureAISearchQueryType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AISearchIndexResource
implements JsonSerializable<AISearchIndexResource> {
    private String indexConnectionId;
    private String indexName;
    private AzureAISearchQueryType queryType;
    private Integer topK;
    private String filter;
    private String indexAssetId;

    public String getIndexConnectionId() {
        return this.indexConnectionId;
    }

    public AISearchIndexResource setIndexConnectionId(String indexConnectionId) {
        this.indexConnectionId = indexConnectionId;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public AISearchIndexResource setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public AzureAISearchQueryType getQueryType() {
        return this.queryType;
    }

    public AISearchIndexResource setQueryType(AzureAISearchQueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public AISearchIndexResource setTopK(Integer topK) {
        this.topK = topK;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public AISearchIndexResource setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getIndexAssetId() {
        return this.indexAssetId;
    }

    public AISearchIndexResource setIndexAssetId(String indexAssetId) {
        this.indexAssetId = indexAssetId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("index_connection_id", this.indexConnectionId);
        jsonWriter.writeStringField("index_name", this.indexName);
        jsonWriter.writeStringField("query_type", this.queryType == null ? null : this.queryType.toString());
        jsonWriter.writeNumberField("top_k", (Number)this.topK);
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeStringField("index_asset_id", this.indexAssetId);
        return jsonWriter.writeEndObject();
    }

    public static AISearchIndexResource fromJson(JsonReader jsonReader) throws IOException {
        return (AISearchIndexResource)jsonReader.readObject(reader -> {
            AISearchIndexResource deserializedAISearchIndexResource = new AISearchIndexResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index_connection_id".equals(fieldName)) {
                    deserializedAISearchIndexResource.indexConnectionId = reader.getString();
                    continue;
                }
                if ("index_name".equals(fieldName)) {
                    deserializedAISearchIndexResource.indexName = reader.getString();
                    continue;
                }
                if ("query_type".equals(fieldName)) {
                    deserializedAISearchIndexResource.queryType = AzureAISearchQueryType.fromString(reader.getString());
                    continue;
                }
                if ("top_k".equals(fieldName)) {
                    deserializedAISearchIndexResource.topK = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedAISearchIndexResource.filter = reader.getString();
                    continue;
                }
                if ("index_asset_id".equals(fieldName)) {
                    deserializedAISearchIndexResource.indexAssetId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAISearchIndexResource;
        });
    }
}

