/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BingCustomSearchConfiguration
implements JsonSerializable<BingCustomSearchConfiguration> {
    private final String connectionId;
    private final String instanceName;
    private String market;
    private Long count;
    private String freshness;
    private String language;

    public BingCustomSearchConfiguration(String connectionId, String instanceName) {
        this.connectionId = connectionId;
        this.instanceName = instanceName;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getMarket() {
        return this.market;
    }

    public BingCustomSearchConfiguration setMarket(String market) {
        this.market = market;
        return this;
    }

    public Long getCount() {
        return this.count;
    }

    public BingCustomSearchConfiguration setCount(Long count) {
        this.count = count;
        return this;
    }

    public String getFreshness() {
        return this.freshness;
    }

    public BingCustomSearchConfiguration setFreshness(String freshness) {
        this.freshness = freshness;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connection_id", this.connectionId);
        jsonWriter.writeStringField("instance_name", this.instanceName);
        jsonWriter.writeStringField("market", this.market);
        jsonWriter.writeStringField("set_lang", this.language);
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeStringField("freshness", this.freshness);
        return jsonWriter.writeEndObject();
    }

    public static BingCustomSearchConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BingCustomSearchConfiguration)jsonReader.readObject(reader -> {
            String connectionId = null;
            String instanceName = null;
            String market = null;
            String language = null;
            Long count = null;
            String freshness = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connection_id".equals(fieldName)) {
                    connectionId = reader.getString();
                    continue;
                }
                if ("instance_name".equals(fieldName)) {
                    instanceName = reader.getString();
                    continue;
                }
                if ("market".equals(fieldName)) {
                    market = reader.getString();
                    continue;
                }
                if ("set_lang".equals(fieldName)) {
                    language = reader.getString();
                    continue;
                }
                if ("count".equals(fieldName)) {
                    count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("freshness".equals(fieldName)) {
                    freshness = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            BingCustomSearchConfiguration deserializedBingCustomSearchConfiguration = new BingCustomSearchConfiguration(connectionId, instanceName);
            deserializedBingCustomSearchConfiguration.market = market;
            deserializedBingCustomSearchConfiguration.language = language;
            deserializedBingCustomSearchConfiguration.count = count;
            deserializedBingCustomSearchConfiguration.freshness = freshness;
            return deserializedBingCustomSearchConfiguration;
        });
    }

    public String getLanguage() {
        return this.language;
    }

    public BingCustomSearchConfiguration setLanguage(String language) {
        this.language = language;
        return this;
    }
}

