/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BingGroundingSearchConfiguration
implements JsonSerializable<BingGroundingSearchConfiguration> {
    private final String connectionId;
    private String market;
    private String setLang;
    private Long count;
    private String freshness;

    public BingGroundingSearchConfiguration(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getMarket() {
        return this.market;
    }

    public BingGroundingSearchConfiguration setMarket(String market) {
        this.market = market;
        return this;
    }

    public String getSetLang() {
        return this.setLang;
    }

    public BingGroundingSearchConfiguration setSetLang(String setLang) {
        this.setLang = setLang;
        return this;
    }

    public Long getCount() {
        return this.count;
    }

    public BingGroundingSearchConfiguration setCount(Long count) {
        this.count = count;
        return this;
    }

    public String getFreshness() {
        return this.freshness;
    }

    public BingGroundingSearchConfiguration setFreshness(String freshness) {
        this.freshness = freshness;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connection_id", this.connectionId);
        jsonWriter.writeStringField("market", this.market);
        jsonWriter.writeStringField("set_lang", this.setLang);
        jsonWriter.writeNumberField("count", (Number)this.count);
        jsonWriter.writeStringField("freshness", this.freshness);
        return jsonWriter.writeEndObject();
    }

    public static BingGroundingSearchConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (BingGroundingSearchConfiguration)jsonReader.readObject(reader -> {
            String connectionId = null;
            String market = null;
            String setLang = null;
            Long count = null;
            String freshness = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connection_id".equals(fieldName)) {
                    connectionId = reader.getString();
                    continue;
                }
                if ("market".equals(fieldName)) {
                    market = reader.getString();
                    continue;
                }
                if ("set_lang".equals(fieldName)) {
                    setLang = reader.getString();
                    continue;
                }
                if ("count".equals(fieldName)) {
                    count = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("freshness".equals(fieldName)) {
                    freshness = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            BingGroundingSearchConfiguration deserializedBingGroundingSearchConfiguration = new BingGroundingSearchConfiguration(connectionId);
            deserializedBingGroundingSearchConfiguration.market = market;
            deserializedBingGroundingSearchConfiguration.setLang = setLang;
            deserializedBingGroundingSearchConfiguration.count = count;
            deserializedBingGroundingSearchConfiguration.freshness = freshness;
            return deserializedBingGroundingSearchConfiguration;
        });
    }
}

