/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.FunctionDefinition;
import com.azure.ai.agents.persistent.models.ToolDefinition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FunctionToolDefinition
extends ToolDefinition {
    private String type = "function";
    private final FunctionDefinition function;

    public FunctionToolDefinition(FunctionDefinition function) {
        this.function = function;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public FunctionDefinition getFunction() {
        return this.function;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("function", (JsonSerializable)this.function);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static FunctionToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (FunctionToolDefinition)jsonReader.readObject(reader -> {
            FunctionDefinition function = null;
            String type = "function";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("function".equals(fieldName)) {
                    function = FunctionDefinition.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            FunctionToolDefinition deserializedFunctionToolDefinition = new FunctionToolDefinition(function);
            deserializedFunctionToolDefinition.type = type;
            return deserializedFunctionToolDefinition;
        });
    }
}

