/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageDeltaContent;
import com.azure.ai.agents.persistent.models.MessageRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MessageDelta
implements JsonSerializable<MessageDelta> {
    private final MessageRole role;
    private final List<MessageDeltaContent> content;

    private MessageDelta(MessageRole role, List<MessageDeltaContent> content) {
        this.role = role;
        this.content = content;
    }

    public MessageRole getRole() {
        return this.role;
    }

    public List<MessageDeltaContent> getContent() {
        return this.content;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MessageDelta fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDelta)jsonReader.readObject(reader -> {
            MessageRole role = null;
            List content = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    role = MessageRole.fromString(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> MessageDeltaContent.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new MessageDelta(role, content);
        });
    }
}

