/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageDeltaContent;
import com.azure.ai.agents.persistent.models.MessageDeltaTextContentObject;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageDeltaTextContent
extends MessageDeltaContent {
    private String type = "text";
    private MessageDeltaTextContentObject text;

    private MessageDeltaTextContent(int index) {
        super(index);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageDeltaTextContentObject getText() {
        return this.text;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("text", (JsonSerializable)this.text);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaTextContent fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaTextContent)jsonReader.readObject(reader -> {
            int index = 0;
            String type = "text";
            MessageDeltaTextContentObject text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = MessageDeltaTextContentObject.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            MessageDeltaTextContent deserializedMessageDeltaTextContent = new MessageDeltaTextContent(index);
            deserializedMessageDeltaTextContent.type = type;
            deserializedMessageDeltaTextContent.text = text;
            return deserializedMessageDeltaTextContent;
        });
    }
}

