/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageDeltaTextAnnotation;
import com.azure.ai.agents.persistent.models.MessageDeltaTextUrlCitationDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageDeltaTextUrlCitationAnnotation
extends MessageDeltaTextAnnotation {
    private String type = "url_citation";
    private final MessageDeltaTextUrlCitationDetails urlCitation;
    private Integer startIndex;
    private Integer endIndex;

    private MessageDeltaTextUrlCitationAnnotation(int index, MessageDeltaTextUrlCitationDetails urlCitation) {
        super(index);
        this.urlCitation = urlCitation;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageDeltaTextUrlCitationDetails getUrlCitation() {
        return this.urlCitation;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeJsonField("url_citation", (JsonSerializable)this.urlCitation);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("start_index", (Number)this.startIndex);
        jsonWriter.writeNumberField("end_index", (Number)this.endIndex);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaTextUrlCitationAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaTextUrlCitationAnnotation)jsonReader.readObject(reader -> {
            int index = 0;
            MessageDeltaTextUrlCitationDetails urlCitation = null;
            String type = "url_citation";
            Integer startIndex = null;
            Integer endIndex = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("url_citation".equals(fieldName)) {
                    urlCitation = MessageDeltaTextUrlCitationDetails.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("start_index".equals(fieldName)) {
                    startIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("end_index".equals(fieldName)) {
                    endIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            MessageDeltaTextUrlCitationAnnotation deserializedMessageDeltaTextUrlCitationAnnotation = new MessageDeltaTextUrlCitationAnnotation(index, urlCitation);
            deserializedMessageDeltaTextUrlCitationAnnotation.type = type;
            deserializedMessageDeltaTextUrlCitationAnnotation.startIndex = startIndex;
            deserializedMessageDeltaTextUrlCitationAnnotation.endIndex = endIndex;
            return deserializedMessageDeltaTextUrlCitationAnnotation;
        });
    }
}

