/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageContent;
import com.azure.ai.agents.persistent.models.MessageImageFileDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageImageFileContent
extends MessageContent {
    private String type = "image_file";
    private final MessageImageFileDetails imageFile;

    private MessageImageFileContent(MessageImageFileDetails imageFile) {
        this.imageFile = imageFile;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageImageFileDetails getImageFile() {
        return this.imageFile;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image_file", (JsonSerializable)this.imageFile);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static MessageImageFileContent fromJson(JsonReader jsonReader) throws IOException {
        return (MessageImageFileContent)jsonReader.readObject(reader -> {
            MessageImageFileDetails imageFile = null;
            String type = "image_file";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image_file".equals(fieldName)) {
                    imageFile = MessageImageFileDetails.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            MessageImageFileContent deserializedMessageImageFileContent = new MessageImageFileContent(imageFile);
            deserializedMessageImageFileContent.type = type;
            return deserializedMessageImageFileContent;
        });
    }
}

