/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.ImageDetailLevel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageImageUrlParam
implements JsonSerializable<MessageImageUrlParam> {
    private final String url;
    private ImageDetailLevel detail;

    public MessageImageUrlParam(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public ImageDetailLevel getDetail() {
        return this.detail;
    }

    public MessageImageUrlParam setDetail(ImageDetailLevel detail) {
        this.detail = detail;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("detail", this.detail == null ? null : this.detail.toString());
        return jsonWriter.writeEndObject();
    }

    public static MessageImageUrlParam fromJson(JsonReader jsonReader) throws IOException {
        return (MessageImageUrlParam)jsonReader.readObject(reader -> {
            String url = null;
            ImageDetailLevel detail = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("detail".equals(fieldName)) {
                    detail = ImageDetailLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            MessageImageUrlParam deserializedMessageImageUrlParam = new MessageImageUrlParam(url);
            deserializedMessageImageUrlParam.detail = detail;
            return deserializedMessageImageUrlParam;
        });
    }
}

