/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageBlockType;
import com.azure.ai.agents.persistent.models.MessageImageUrlParam;
import com.azure.ai.agents.persistent.models.MessageInputContentBlock;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageInputImageUrlBlock
extends MessageInputContentBlock {
    private MessageBlockType type = MessageBlockType.IMAGE_URL;
    private final MessageImageUrlParam imageUrl;

    public MessageInputImageUrlBlock(MessageImageUrlParam imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Override
    public MessageBlockType getType() {
        return this.type;
    }

    public MessageImageUrlParam getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image_url", (JsonSerializable)this.imageUrl);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static MessageInputImageUrlBlock fromJson(JsonReader jsonReader) throws IOException {
        return (MessageInputImageUrlBlock)jsonReader.readObject(reader -> {
            MessageImageUrlParam imageUrl = null;
            MessageBlockType type = MessageBlockType.IMAGE_URL;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image_url".equals(fieldName)) {
                    imageUrl = MessageImageUrlParam.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = MessageBlockType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            MessageInputImageUrlBlock deserializedMessageInputImageUrlBlock = new MessageInputImageUrlBlock(imageUrl);
            deserializedMessageInputImageUrlBlock.type = type;
            return deserializedMessageInputImageUrlBlock;
        });
    }
}

