/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageTextAnnotation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MessageTextDetails
implements JsonSerializable<MessageTextDetails> {
    private final String value;
    private final List<MessageTextAnnotation> annotations;

    private MessageTextDetails(String value, List<MessageTextAnnotation> annotations) {
        this.value = value;
        this.annotations = annotations;
    }

    public String getValue() {
        return this.value;
    }

    public List<MessageTextAnnotation> getAnnotations() {
        return this.annotations;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeArrayField("annotations", this.annotations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MessageTextDetails fromJson(JsonReader jsonReader) throws IOException {
        return (MessageTextDetails)jsonReader.readObject(reader -> {
            String value = null;
            List annotations = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    value = reader.getString();
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    annotations = reader.readArray(reader1 -> MessageTextAnnotation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new MessageTextDetails(value, annotations);
        });
    }
}

