/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageTextAnnotation;
import com.azure.ai.agents.persistent.models.MessageTextUrlCitationDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageTextUrlCitationAnnotation
extends MessageTextAnnotation {
    private String type = "url_citation";
    private final MessageTextUrlCitationDetails urlCitation;
    private Integer startIndex;
    private Integer endIndex;

    private MessageTextUrlCitationAnnotation(String text, MessageTextUrlCitationDetails urlCitation) {
        super(text);
        this.urlCitation = urlCitation;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageTextUrlCitationDetails getUrlCitation() {
        return this.urlCitation;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.getText());
        jsonWriter.writeJsonField("url_citation", (JsonSerializable)this.urlCitation);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("start_index", (Number)this.startIndex);
        jsonWriter.writeNumberField("end_index", (Number)this.endIndex);
        return jsonWriter.writeEndObject();
    }

    public static MessageTextUrlCitationAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return (MessageTextUrlCitationAnnotation)jsonReader.readObject(reader -> {
            String text = null;
            MessageTextUrlCitationDetails urlCitation = null;
            String type = "url_citation";
            Integer startIndex = null;
            Integer endIndex = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("url_citation".equals(fieldName)) {
                    urlCitation = MessageTextUrlCitationDetails.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("start_index".equals(fieldName)) {
                    startIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("end_index".equals(fieldName)) {
                    endIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            MessageTextUrlCitationAnnotation deserializedMessageTextUrlCitationAnnotation = new MessageTextUrlCitationAnnotation(text, urlCitation);
            deserializedMessageTextUrlCitationAnnotation.type = type;
            deserializedMessageTextUrlCitationAnnotation.startIndex = startIndex;
            deserializedMessageTextUrlCitationAnnotation.endIndex = endIndex;
            return deserializedMessageTextUrlCitationAnnotation;
        });
    }
}

