/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.OpenApiAnonymousAuthDetails;
import com.azure.ai.agents.persistent.models.OpenApiAuthType;
import com.azure.ai.agents.persistent.models.OpenApiConnectionAuthDetails;
import com.azure.ai.agents.persistent.models.OpenApiManagedAuthDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class OpenApiAuthDetails
implements JsonSerializable<OpenApiAuthDetails> {
    private OpenApiAuthType type = OpenApiAuthType.fromString("OpenApiAuthDetails");

    public OpenApiAuthType getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OpenApiAuthDetails fromJson(JsonReader jsonReader) throws IOException {
        return (OpenApiAuthDetails)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                OpenApiAuthDetails openApiAuthDetails;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("anonymous".equals(discriminatorValue)) {
                    openApiAuthDetails = OpenApiAnonymousAuthDetails.fromJson(readerToUse.reset());
                    return openApiAuthDetails;
                }
                if ("connection".equals(discriminatorValue)) {
                    openApiAuthDetails = OpenApiConnectionAuthDetails.fromJson(readerToUse.reset());
                    return openApiAuthDetails;
                }
                if ("managed_identity".equals(discriminatorValue)) {
                    openApiAuthDetails = OpenApiManagedAuthDetails.fromJson(readerToUse.reset());
                    return openApiAuthDetails;
                }
                openApiAuthDetails = OpenApiAuthDetails.fromJsonKnownDiscriminator(readerToUse.reset());
                return openApiAuthDetails;
            }
        });
    }

    static OpenApiAuthDetails fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (OpenApiAuthDetails)jsonReader.readObject(reader -> {
            OpenApiAuthDetails deserializedOpenApiAuthDetails = new OpenApiAuthDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedOpenApiAuthDetails.type = OpenApiAuthType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenApiAuthDetails;
        });
    }
}

