/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.FunctionDefinition;
import com.azure.ai.agents.persistent.models.OpenApiAuthDetails;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class OpenApiFunctionDefinition
implements JsonSerializable<OpenApiFunctionDefinition> {
    private final String name;
    private String description;
    private final BinaryData spec;
    private final OpenApiAuthDetails auth;
    private List<String> defaultParams;
    private List<FunctionDefinition> functions;

    public OpenApiFunctionDefinition(String name, BinaryData spec, OpenApiAuthDetails auth) {
        this.name = name;
        this.spec = spec;
        this.auth = auth;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public OpenApiFunctionDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    public BinaryData getSpec() {
        return this.spec;
    }

    public OpenApiAuthDetails getAuth() {
        return this.auth;
    }

    public List<String> getDefaultParams() {
        return this.defaultParams;
    }

    public OpenApiFunctionDefinition setDefaultParams(List<String> defaultParams) {
        this.defaultParams = defaultParams;
        return this;
    }

    public List<FunctionDefinition> getFunctions() {
        return this.functions;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeFieldName("spec");
        this.spec.writeTo(jsonWriter);
        jsonWriter.writeJsonField("auth", (JsonSerializable)this.auth);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("default_params", this.defaultParams, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static OpenApiFunctionDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (OpenApiFunctionDefinition)jsonReader.readObject(reader -> {
            String name = null;
            BinaryData spec = null;
            OpenApiAuthDetails auth = null;
            String description = null;
            List defaultParams = null;
            List functions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("spec".equals(fieldName)) {
                    spec = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("auth".equals(fieldName)) {
                    auth = OpenApiAuthDetails.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("default_params".equals(fieldName)) {
                    defaultParams = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("functions".equals(fieldName)) {
                    functions = reader.readArray(reader1 -> FunctionDefinition.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            OpenApiFunctionDefinition deserializedOpenApiFunctionDefinition = new OpenApiFunctionDefinition(name, spec, auth);
            deserializedOpenApiFunctionDefinition.description = description;
            deserializedOpenApiFunctionDefinition.defaultParams = defaultParams;
            deserializedOpenApiFunctionDefinition.functions = functions;
            return deserializedOpenApiFunctionDefinition;
        });
    }
}

